#ifndef __OMS_SINKCRITICALSECTION_HPP
#define __OMS_SINKCRITICALSECTION_HPP

#include "ilivecachesink.h" // nocheck
#include "Oms/OMS_DbpBase.hpp"
#include "liveCache/LVC_IliveCacheSink.hpp"

class OMS_SinkCriticalSection {
private :
  IliveCacheSink*   m_lcSink;
  int               m_regionId;
  bool              m_inSection;
public :
  OMS_SinkCriticalSection(IliveCacheSink* lcSink,int regionId) : m_lcSink(lcSink), m_regionId(regionId), m_inSection(false) {} 

  void Enter() {
    if (m_inSection) {
      throw DbpError(DbpError::RTE_ERROR, -1, __MY_FILE__, __LINE__); 
    }
    else {
      m_lcSink->EnterCriticalSection(m_regionId);
      m_inSection = true;
    }
  }

  void Leave() {
    if (m_inSection) {
      m_lcSink->LeaveCriticalSection(m_regionId);
      m_inSection = false;
    }
    else {
      throw DbpError(DbpError::RTE_ERROR, -1, __MY_FILE__, __LINE__); 
    }
  }
  ~OMS_SinkCriticalSection() {
    if (m_inSection) {
      Leave();
    }
  }
};

#endif  // __OMS_SINKCRITICALSECTION_HPP
