/*!
    @ingroup        Restart
    @file           Rst_RedoTrafficControl.hpp
    @author         JuergenA
    @author         UweH
    @brief          defines a class to allocate the RedoTrafficControl singleton
*/
/*

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


 */



#ifndef RST_REDO_TRAFFIC_CONTROL_H
#define RST_REDO_TRAFFIC_CONTROL_H


/*===========================================================================*
*  INCLUDES                                                                  *
*============================================================================*/

#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"

/*===========================================================================*
*  CLASSES                                                                   *
*============================================================================*/

//=======================================================================================
/*!
  @class          Rst_RedoAllocateTrafficControl
   @brief          a class to allocate the RedoTrafficControl singleton

 */

class Rst_RedoAllocateTrafficControl
{
public:
    
    //----------------------------------------------------------------------------
    /*!
       @brief          constructor without any allocation of the singleton RedoTrafficControl

     */

    Rst_RedoAllocateTrafficControl ()
    { }
    
    //----------------------------------------------------------------------------
    /*!
       @brief          deallocates the singleton RedoTrafficControl

     */

    ~Rst_RedoAllocateTrafficControl ();
    
    //----------------------------------------------------------------------------
    /*!
       @brief          allocates the singleton RedoTrafficControl
       @param          RawAllocator    [in out] 
       @param          redoIsAborted   [in out]
       @param          inserted        [in out]
       @param          removed         [in out]
       @param          IsOk               [out] 

     */

    void Allocate (
        SAPDBMem_IRawAllocator &RawAllocator,
        volatile bool          &redoIsAborted,
        SAPDB_UInt             &inserted,
        SAPDB_UInt             &removed,
        bool                   &IsOk);
};


#endif  /* RST_REDO_TRAFFIC_CONTROL_H */
