/*!---------------------------------------------------------------------
  @file           SAPDB_Names.h
  @author         RobinW
  @brief          a collection of commonly used name definitions

  first created  2003-05-20  09:22

\if EMIT_LICENCE
    ========== licence begin GPL
    Copyright (c) 2002-2004 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end
\endif
---------------------------------------------------------------------*/
#ifndef SAPDB_NAMES_H
#define SAPDB_NAMES_H

/*! the name of the database message file */
#define SAPDB_DIAG_FILE_NAME            "knldiag"

/*! the name of the error messages file */
#define SAPDB_ERROR_FILE_NAME           "knldiag.err"

#if !defined(WIN32)

/*---------- Registry file path definition (UNIX only) ------------------*/

/*! the name of the old global configuration directory on UNIX */
#define SAPDB_OLD_GLOBAL_DIRECTORY "/usr/spool/sql/"

/*! the name of the old global configuration directory on UNIX */
#define SAPDB_OLD_GLOBAL_CONFIG_DIRECTORY "/usr/spool/sql/ini"

/*! the name of the old global configuration file on UNIX which contained, globals, databases and runtimes */
#define SAPDB_OLD_GLOBAL_COMMON_CONFIG_FILE "SAP_DBTech.ini"

/*! the name of the directory containing the global config file on UNIX */
#define SAPDB_GLOBAL_CONFIG_DIRECTORY   "/etc/opt"

/*! the name of the global configuration file on UNIX */
#define SAPDB_GLOBAL_CONFIG_FILE        SAPDB_GLOBAL_CONFIG_DIRECTORY "/sdb"

/*! the name of the global database registration file on UNIX */
#define SAPDB_DATABASES_INI_FILE        "Databases.ini"

/*! the name of the global instalation registration file on UNIX */
#define SAPDB_INSTALLATIONS_INI_FILE    "Installations.ini"

/*! the name of the global precompiler runtime registration file on UNIX and WINDOWS */
#  define SAPDB_RUNTIMES_INI_FILE          "Runtimes.ini"

/*! the name of the ODBC driver registration file on UNIX */
#  define SAPDB_ODBC_INI_FILE              "odbc.ini"

/*! the name of the ODBC driver registration file on UNIX */
#  define SAPDB_ODBCINST_INI_FILE          "ODBCINST.ini"

/*! the name of the section for globals in the global configuration file on UNIX */
#define SAPDB_GLOBALS_SECTION           "Globals"

/*! the name of the DIAG console pipe subdirectory */
#define SAPDB_SPOOL_DIAG_DIRECTORY "diag"

/*! the name of the FIFO requestor pipe subdirectory */
#define SAPDB_SPOOL_FIFO_DIRECTORY "fifo"

/*! the name of the pipe subdirectory */
#define SAPDB_SPOOL_PIPE_DIRECTORY "pipe"

/*! the name of the IPC tag file subdirectory */
#define SAPDB_SPOOL_IPC_DIRECTORY  "ipc"

/*! the name of the database process id file subdirectory */
#define SAPDB_SPOOL_PID_DIRECTORY  "pid"

/*! the name of the database watchdog process id file subdirectory */
#define SAPDB_SPOOL_PPID_DIRECTORY  "ppid"

/*! the name of the database speed id file subdirectory */
#define SAPDB_SPOOL_DBSPEED_DIRECTORY  "dbspeed"

/*! the prefix of the IPC tag file directory for database tags */
#define SAPDB_DATABASE_DIRECTORY_PREFIX "db:"

/*! the prefix of the IPC tag file directory for user tags */
#define SAPDB_USER_DIRECTORY_PREFIX     "us:"

/*---------- End of registry file path definition (UNIX only) ------------------*/

#else /* WIN32 */

/*---------- Registry path definition (WINDOWS only) ------------------*/

#  define SAPDB_GLOBAL_CONFIG_FILE       "Software\\SAP\\SAP DBTech"

/*! the name of the section for globals in the global configuration file on Windows */
#  define SAPDB_GLOBALS_SECTION          ""

/*! the name of the global precompiler runtime registration on WINDOWS */
#  define SAPDB_RUNTIMES_INI_FILE        SAPDB_GLOBAL_CONFIG_FILE

/*! the name of the ODBC driver registration */
#  define SAPDB_ODBC_INI_FILE            "odbc.ini"

/*! the name of the ODBC datasource registration */
#  define SAPDB_ODBCINST_INI_FILE          "Software\\ODBC\\ODBCINST.INI"

/*--------End of registry path definition (WINDOWS only) --------------*/

#endif /* WIN32 */

/*! the name of the key in the globals section for the independend data path key */
#define SAPDB_INDEPDATA_KEY             "IndepData"

/*! the name of the key in the globals section for the independend programs key */
#define SAPDB_INDEPPROGRAMS_KEY         "IndepPrograms"

/*! the name of the key in the globals section for the user name of the owner of sapdb software and database processes */
#define SAPDB_SAPDBOWNER_KEY            "SdbOwner"

/*! the name of the key in the globals section for the administration group */
#define SAPDB_SAPDBGROUP_KEY            "SdbGroup"

/*! the name of the section for databases in the global database registration file on UNIX */
#define SAPDB_DATABASES_SECTION         "Databases"

/*! the name of the section for installations in the global installation registration file on UNIX */
#define SAPDB_INSTALLATIONS_SECTION     "Installations"

/*! the name of the section in the global precompiler runtime registration file on UNIX */
#define SAPDB_RUNTIME_SECTION           "Runtime"

/*---------- Subdirectory names-----------------------------------*/
/*! the subdirectory name containing INI files etc. */
#define SAPDB_CONFIG_SUBPATH            "config"

/*! the subdirectory name containing INI files etc. in $HOME */
#define SAPDB_HOME_SUBDIRECTORY        ".sdb"

/*---------- Environmentvariables---------------------------------*/
/*! the name of the environment variable to overrule $HOME/.sdb */
#define SAPDB_HOMEDIRECTORY             "SAPDB_HOMEDIRECTORY"

/*! the name of the environment variable to overrule usage of indepPath */
#define SAPDB_NO_INDEPPATH              "SAPDB_NO_INDEPPATH"
/*--------------------------------------------------------------------*/
#endif /* SAPDB_NAMES_H */
