/****************************************************************************/
/*!

  @file        SysView_IndexSizeDetails.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "IndexSizeDetails" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_IndexSizeDetails.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_IndexSizeDetails::Create()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_IndexSizeDetails::Create", SysView_Trace, 5);

	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_OWNER, 32);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_TABLENAME, 32);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_INDEXNAME, 32);
	m_Table->AppendCol (ITOCT_CHARUNICODE ,SV_COLUMNNAME, 32);
	m_Table->AppendCol (ITOCT_FIXED ,SV_ROOT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_USEDSIZE, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_USEDDATASIZE, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_TREELEVELCOUNT, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_AVGUSEDSIZEPERCENTAGEINLEAVES, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MINUSEDSIZEPERCENTAGEINLEAVES, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXUSEDSIZEPERCENTAGEINLEAVES, 3);
	m_Table->AppendCol (ITOCT_FIXED ,SV_SECONDARYKEYCOUNT, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_AVGSECONDARYKEYLENGTH, 4);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MINSECONDARYKEYLENGTH, 4);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXSECONDARYKEYLENGTH, 4);
	m_Table->AppendCol (ITOCT_FIXED ,SV_AVGSEPARATORLENGTH, 4);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MINSEPARATORLENGTH, 4);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXSEPARATORLENGTH, 4);
	m_Table->AppendCol (ITOCT_FIXED ,SV_AVGROWCOUNTPERSECONDARYKEY, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MINROWCOUNTPERSECONDARYKEY, 10);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXROWCOUNTPERSECONDARYKEY, 10);

}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_IndexSizeDetails::GetColCount()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_IndexSizeDetails::GetColCount", SysView_Trace, 5);

    return SV_CC_INDEXSIZEDETAILS;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_IndexSizeDetails::EstimateRows()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_IndexSizeDetails::EstimateRows", SysView_Trace, 5);

    return SV_ER_INDEXSIZEDETAILS;
}

/*---------------------------------------------------------------------------*/

void SysView_IndexSizeDetails::Execute()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_IndexSizeDetails::Execute", SysView_Trace, 5);

    m_Context.ThrowError (e_not_implemented, 1);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
