/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */


/*
 * The basic globbing matcher.
 *
 * "*"           = match 0 or more occurances of anything
 * "[abc]"       = match any of "abc" (ranges supported)
 * "{xx,yy,...}" = match any of "xx", "yy", ... where
 *                 "xx", "yy" can be any pattern or empty
 * "?"           = match any character
 *
 *
 * In the state this is in, it will probably barf when passed "}" and stuff.
 * Ripped from the mush distribution.
 *
 *
 */

#include <stdio.h>

#include "glob.h"

int
glob(str, pat)
char *str, *pat;
{
    int done = 0, ret = 0;

    if (!str || !pat)
	return 0;

    while (*pat && !done && (*str || (*pat == '{' || *pat == '*'))) /*}*/ {
	/*
	 * First look for a literal match, stepping over backslashes
	 * in the pattern to match against the "protected" character.
	 * Ordering and precendence are important in this expression!
	 */
	if ((*pat == '\\' && *str == *++pat) || *str == *pat) {
	    str++;
	    pat++;
	} else switch (*pat++) {
	    case '*':	/* Match any string */
		if (!*pat) {
		    while (*str)
			str++;
		    break;
		}
		/*
		 * Try the rest of the glob against every
		 * possible suffix of the string.  A bit
		 * inefficient in cases that eventually fail.
		 */
		while (*str && !(ret = glob(str++, pat)))
		    ;
		return ret;
		break;
	    case '[':	/* Match a set */
	    repeat:
		/* If we've hit the end of the set, give up. */
		if ((!*pat || *pat == ']' || *pat == '\\') && !*++pat) {
		    done = 1;
		    break;
		}
		/* Check for a range. */
		if (*(pat + 1) == '-') {
		    char c = *pat++;
		    /* We don't handle open-ended ranges. */
		    if ((*++pat == ']' || *pat == '\\') && !*++pat) {
			done = 1;
			break;
		    }
		    if (*str < c || *str > *pat) {
			pat++;
			goto repeat;
		    }
		} else if (*pat != *str) {
		    pat++;
		    goto repeat;
		}
		/*
		 * We matched either the range or a literal member of
		 * the set.  Skip to the end of the set.
		 */
		pat++;
		while (*pat && *pat != ']')
		    if (*pat++ == '\\' && *pat)
			pat++;
		/*
		 * If no pattern remains, the set was never closed,
		 * so don't increment.  This will cause a FALSE return.
		 */
		if (*pat) {
		    pat++;
		    str++;
		}
		break;
	    case '?':	/* Match any one character */
		str++;
		break;
	    case '{':	/* } Match any of a set of patterns */
	      /*return sglob(str, pat - 1, TRPL_NULL);*/
		break;
	    default:
		done = 1;
	}
    }
    while (*pat == '*')
	pat++;
    return ((*str == '\0') && (*pat == '\0'));
}


#ifdef DEBUG_GLOB

int
main(int argc, char **argv) {
  char s1[128], s2[128];

  while(1) {
    fscanf(stdin, "%s %s", s1, s2);
    printf("%d\n", glob(s1, s2));
  }
}
#endif
