/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: random.h,v 1.3 2003/02/05 04:38:37 kos Exp $
 *
 */

#ifndef _RANDOM_H
#define _RANDOM_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <limits.h>
#include <openssl/md5.h>

#include "keyspace.h"
#include "generator.h"

#define RNG_MAX_LENGTH MD5_DIGEST_LENGTH
#define RNG_DEF_SEED "BURGERKINGNG"
#define RNG_DEF_LENGTH 4
#define RNG_MAXRES ULONG_MAX
#define RNG_MINRES 0

typedef struct random_t {
  unsigned char seed[RNG_MAX_LENGTH];
  unsigned char x_n[RNG_MAX_LENGTH];
  key_index_t index;
  key_index_t minindex;
  key_index_t maxindex;
  int len;
} random_t;

random_t *random_init(char *params);
int random_set(random_t *, key_index_t index);
int random_fetch(random_t *, kchar *buf, int len, int *rlen);
int random_done(random_t *);
int random_destroy(random_t *);
key_index_t *random_minindex(random_t *);
key_index_t *random_maxindex(random_t *);
key_index_t *random_curindex(random_t *);
int random_minlen(random_t *);
int random_maxlen(random_t *);

#endif /* _RANDOM_H */
