/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: method.h,v 1.7 2000/11/14 03:18:30 kos Exp $
 *
 */

#ifndef _METHOD_H
#define _METHOD_H

#define METH_LINELEN 128

#include "keyspace.h"
#include "array.h"

typedef void *(*meth_init)(char *params);
typedef int (*meth_test)(void *context, kchar);
typedef int (*meth_crypt)(void *context);
typedef int (*meth_add)(void *context, kchar *key, int len);
typedef int (*meth_siz)(void *context);
typedef int (*meth_sethash)(void *context, kchar *hash, int len);
typedef int (*meth_setsalt)(void *context, kchar *salt, int len);
typedef int (*meth_getkey)(void *context, kchar *, int, int *, int *);
typedef int (*meth_destroy)(void *context);

typedef struct method_impl_t {
  char *name;
  meth_init init;
  meth_test test;
  meth_crypt crypt;
  meth_add add;
  meth_siz siz;
  meth_sethash sethash;
  meth_setsalt setsalt;
  meth_getkey getkey;
  meth_destroy destroy;  
} method_impl_t;

typedef struct method_t {
  char name[METH_LINELEN];
  char opts[METH_LINELEN];
  method_impl_t *impl;
  void *context;
} method_t;
  
int method_query(int index, char *buf, int len);
method_t *method_init(char *name, char *params);
#define method_test(x) ((x)->impl->test((x)->context))
#define method_crypt(x) ((x)->impl->crypt((x)->context))
#define method_add(x,y,z) ((x)->impl->add((x)->context,y,z))
#define method_siz(x) ((x)->impl->siz((x)->context))
#define method_sethash(x,y,z) ((x)->impl->sethash((x)->context,y,z))
#define method_setsalt(x,y,z) ((x)->impl->sethash((x)->context,y,z))
#define method_getkey(x,y,z,i,j) ((x)->impl->getkey((x)->context,y,z,i,j))
#define method_destroy(x) ((x)->impl->destroy((x)->context))

#endif /* _METHOD_H */
