/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * $Id: simple.h,v 1.2 2004/06/09 01:36:53 kos Exp $
 *
 */

#ifndef _SIMPLE_H
#define _SIMPLE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "method.h"
#include "keyspace.h"
#include "array.h"

#define UNIXCRYPT_HASHLEN 13

typedef struct unixcrypt_key_t {
  char key[14];
} unixcrypt_key_t;

typedef struct unixcrypt_t {
  array *pool;
  char hash[METH_LINELEN];
  char salt[4];
  char key[14];
  int index;
} unixcrypt_t;

#define MD5_MAX_KEYLEN 64
#define MD5_MAGIC "$1$"
#define MD5_MAGIC_LEN 3
#define MD5_HASHLEN 16

typedef struct md5raw_key_t {
  char key[MD5_MAX_KEYLEN];
  int len;
} md5raw_key_t;

typedef struct md5raw_t {
  array *pool;
  uchar hash[METH_LINELEN];
  char salt[METH_LINELEN];
  char key[METH_LINELEN];
  int len;
  int index;
  int found;
} md5raw_t;

typedef struct md5_key_t {
  uchar key[MD5_MAX_KEYLEN];
  int len;
} md5_key_t;

typedef struct md5_t {
  array *pool;
  uchar hash[METH_LINELEN];
  uchar salt[METH_LINELEN];
  uchar key[METH_LINELEN];
  int len;
  int index;
  int found;
} md5_t;

#define SHA_MAX_KEYLEN 64
#define SHA_HASHLEN 20
#define SHA_NS_MAGIC "{SHA}"
#define SHA_NS_MAGIC_LEN 5

typedef struct sharaw_key_t {
  uchar key[SHA_MAX_KEYLEN];
  int len;
} sharaw_key_t;

typedef struct sharaw_t {
  array *pool;
  uchar hash[METH_LINELEN];
  uchar salt[METH_LINELEN];
  uchar key[METH_LINELEN];
  int len;
  int index;
  int found;
} sharaw_t;


#define MD2_MAX_KEYLEN 64
#define MD2_HASHLEN 16

typedef struct md2raw_key_t {
  uchar key[MD2_MAX_KEYLEN];
  int len;
} md2raw_key_t;

typedef struct md2raw_t {
  array *pool;
  uchar hash[METH_LINELEN];
  uchar salt[METH_LINELEN];
  uchar key[METH_LINELEN];
  int len;
  int index;
  int found;
} md2raw_t;

#define DOMINO_MAX_KEYLEN 10
#define DOMINO_HASHLEN 16


typedef struct domino_key_t {
  uchar key[DOMINO_MAX_KEYLEN];
  int len;
} domino_key_t;

typedef struct domino_t {
  array *pool;
  uchar hash[METH_LINELEN];
  uchar salt[METH_LINELEN];
  uchar key[METH_LINELEN];
  int len;
  int index;
  int found;
} domino_t;

#endif /* _SIMPLE_H */
