/*
dbase.h - MessageWall database declarations
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _DBASE_H
#define _DBASE_H

#include "messagewall.h"

void dbase_clear();
void dbase_load_local_domains();
void dbase_load_relay_ips();
void dbase_load_special_users();
void dbase_load();

unsigned int dbase_binary_hash(struct firestring_estr_t *domain, int start);
unsigned int dbase_text_hash(struct firestring_estr_t *address, int start);
unsigned int dbase_ip_hash(unsigned char *ip);
int dbase_domain_is_local(struct firestring_estr_t *domain);
int dbase_ip_can_relay(unsigned char *ip);

void dbase_load_header_reject(struct firestring_conf_t *config, struct messagewall_header_reject_t **head, const char *name);
void dbase_load_estr_ll(struct firestring_conf_t *config, struct messagewall_estr_ll_t **head, const char *name);
void dbase_load_int(struct firestring_conf_t *config, int *value, const char *name);

struct messagewall_dnsbl_global_t *dbase_get_dnsbl(const char *dnsbl, struct messagewall_dnsbl_global_t **global_head);
struct messagewall_dnsdcc_global_t *dbase_get_dnsdcc(const char *dnsdcc);
struct messagewall_profile_t *dbase_get_profile(const char *name);
void dbase_load_profiles(const char *profile_dir);

#endif
