/* Mac-on-Linux ELF loader 

   Copyright (C) 2001-2002 Samuel Rydh

   adapted from yaboot

   Copyright (C) 1999 Benjamin Herrenschmidt

   portions based on poof

   Copyright (C) 1999 Marius Vollmer

   portions based on quik
   
   Copyright (C) 1996 Paul Mackerras.

   Because this program is derived from the corresponding file in the
   silo-0.64 distribution, it is also

   Copyright (C) 1996 Pete A. Zaitcev
   		 1996 Maurizio Plaza
   		 1996 David S. Miller
   		 1996 Miguel de Icaza
   		 1996 Jakub Jelinek

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
*/

#include "of.h"
#include "elfload.h"

#define DEBUG		0
#define MAX_HEADERS	32
#define BS		0x100	/* smallest step used when looking for ELF header */


int
find_elf32( fs_ops_t *fs, file_desc_t fd )
{
	int size, offs;
	
	if( (size = fs->lseek( fd, 0, SEEK_END )) < 0 )
		return -1;
	
	for(offs=0; offs<size; offs+= BS )
		if( is_elf32( fs, fd, offs ) )
			return offs;
	return -1;
}

int
is_elf32( fs_ops_t *fs, file_desc_t fd, int offs )
{
	Elf32_Ehdr e;
	int size = sizeof(e);

	fs->lseek( fd, offs, SEEK_SET );
	if( fs->read(fd, &e, size) < size ) {
		printm("\nCan't read Elf32 image header\n");
		return 0;
	}

	return (e.e_ident[EI_MAG0]  == ELFMAG0	    &&
		e.e_ident[EI_MAG1]  == ELFMAG1	    &&
		e.e_ident[EI_MAG2]  == ELFMAG2	    &&
		e.e_ident[EI_MAG3]  == ELFMAG3	    &&
		e.e_ident[EI_CLASS] == ELFCLASS32  &&
		e.e_ident[EI_DATA]  == ELFDATA2MSB &&
		e.e_type            == ET_EXEC	    &&
		e.e_machine         == EM_PPC);
}

Elf32_Phdr *
elf32_readhdrs( fs_ops_t *fs, file_desc_t fd, int offs, Elf32_Ehdr *e )
{
	int size = sizeof(Elf32_Ehdr);
	Elf32_Phdr *ph;
	
	if( !is_elf32( fs, fd, offs) ) {
		printm("elf32_getphds: not an ELF image\n");
		return NULL;
	}
	
	fs->lseek( fd, offs, SEEK_SET );
	if( fs->read(fd, e, size) < size ) {
		printm("\nCan't read Elf32 image header\n");
		return NULL;
	}
	
#if DEBUG
	printm("Elf32 header:\n");
	printm(" e.e_type    = %d\n", (int)e->e_type);
	printm(" e.e_machine = %d\n", (int)e->e_machine);
	printm(" e.e_version = %d\n", (int)e->e_version);
	printm(" e.e_entry   = 0x%08x\n", (int)e->e_entry);
	printm(" e.e_phoff   = 0x%08x\n", (int)e->e_phoff);
	printm(" e.e_shoff   = 0x%08x\n", (int)e->e_shoff);
	printm(" e.e_flags   = %d\n", (int)e->e_flags);
	printm(" e.e_ehsize  = 0x%08x\n", (int)e->e_ehsize);
	printm(" e.e_phentsize = 0x%08x\n", (int)e->e_phentsize);
	printm(" e.e_phnum   = %d\n", (int)e->e_phnum);
#endif
	if (e->e_phnum > MAX_HEADERS) {
		printm ("elfload: too many program headers (MAX_HEADERS)\n");
		return NULL;
	}

	size = sizeof(Elf32_Phdr) * e->e_phnum;
	if( !(ph=(Elf32_Phdr *)malloc(size)) ) {
		printm("malloc error\n");
		return NULL;
	}

	/* Now, we read the section header */
	fs->lseek( fd, offs+e->e_phoff, SEEK_SET );
	if( fs->read(fd, ph, size) != size ) {
		printm("read error");
		free( ph );
		return NULL;
	}
	return ph;
}

