/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.Category;
import base.drawable.CategoryWeight;
import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.statistics.CategoryTimeBox;
import base.statistics.DrawOrderComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public class TimeAveBox
extends TimeBoundingBox {
    private static final DrawOrderComparator DRAWING_ORDER = new DrawOrderComparator();
    private Map map_type2twgt = new HashMap();
    private List list_nestables;
    private SortedSet set_timeblocks;
    private CategoryTimeBox[] typebox_ary = null;
    private double num_real_objs = 0.0;
    private double box_duration = super.getDuration();
    private TimeBoundingBox curr_timebox = null;

    public TimeAveBox(TimeBoundingBox timeBoundingBox, boolean bl) {
        super(timeBoundingBox);
        if (bl) {
            this.list_nestables = new ArrayList();
            this.set_timeblocks = new TreeSet(DRAWING_ORDER);
        } else {
            this.list_nestables = null;
            this.set_timeblocks = null;
        }
    }

    public TimeAveBox(TimeAveBox timeAveBox) {
        this(timeAveBox, timeAveBox.list_nestables != null);
        this.mergeWithTimeAveBox(timeAveBox);
    }

    public void mergeWithReal(Drawable drawable) {
        double d = super.getIntersectionDuration(drawable);
        float f = (float)(d / this.box_duration);
        Category category = drawable.getCategory();
        CategoryWeight categoryWeight = (CategoryWeight)this.map_type2twgt.get(category);
        if (categoryWeight == null) {
            categoryWeight = new CategoryWeight(category, f, 0.0f);
            this.map_type2twgt.put(category, categoryWeight);
        } else {
            categoryWeight.addInclusiveRatio(f);
        }
        this.num_real_objs += d / drawable.getDuration() * (double)drawable.getNumOfPrimitives();
        if (this.list_nestables != null) {
            this.list_nestables.add(drawable);
        }
    }

    public void mergeWithShadow(Shadow shadow) {
        double d = super.getIntersectionDuration(shadow);
        float f = (float)(d / this.box_duration);
        CategoryWeight[] categoryWeightArray = shadow.arrayOfCategoryWeights();
        for (int i = categoryWeightArray.length - 1; i >= 0; --i) {
            CategoryWeight categoryWeight = categoryWeightArray[i];
            Category category = categoryWeight.getCategory();
            CategoryWeight categoryWeight2 = (CategoryWeight)this.map_type2twgt.get(category);
            if (categoryWeight2 == null) {
                categoryWeight2 = new CategoryWeight(categoryWeight);
                categoryWeight2.rescaleAllRatios(f);
                this.map_type2twgt.put(category, categoryWeight2);
                continue;
            }
            categoryWeight2.addAllRatios(categoryWeight, f);
        }
        this.num_real_objs += d / shadow.getDuration() * (double)shadow.getNumOfRealObjects();
        if (this.list_nestables != null) {
            this.set_timeblocks.add(shadow);
        }
    }

    public void mergeWithTimeAveBox(TimeAveBox timeAveBox) {
        double d = super.getIntersectionDuration(timeAveBox);
        float f = (float)(d / this.box_duration);
        Iterator iterator = timeAveBox.map_type2twgt.values().iterator();
        while (iterator.hasNext()) {
            CategoryWeight categoryWeight = (CategoryWeight)iterator.next();
            Category category = categoryWeight.getCategory();
            CategoryWeight categoryWeight2 = (CategoryWeight)this.map_type2twgt.get(category);
            if (categoryWeight2 == null) {
                categoryWeight2 = new CategoryWeight(categoryWeight);
                categoryWeight2.rescaleAllRatios(f);
                this.map_type2twgt.put(category, categoryWeight2);
                continue;
            }
            categoryWeight2.addAllRatios(categoryWeight, f);
        }
        this.num_real_objs += d / timeAveBox.getDuration() * timeAveBox.num_real_objs;
        if (this.list_nestables != null) {
            this.set_timeblocks.add(timeAveBox);
        }
    }

    private void patchSetOfTimeBlocks() {
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox(TimeBoundingBox.ALL_TIMES);
        TimeBoundingBox timeBoundingBox2 = null;
        if (!this.set_timeblocks.isEmpty()) {
            timeBoundingBox2 = (TimeBoundingBox)this.set_timeblocks.first();
        }
        if (timeBoundingBox2 != null && timeBoundingBox2.contains(super.getEarliestTime())) {
            timeBoundingBox.setLatestTime(timeBoundingBox2.getEarliestTime());
        } else {
            timeBoundingBox.setLatestTime(super.getEarliestTime());
        }
        this.set_timeblocks.add(timeBoundingBox);
        timeBoundingBox = new TimeBoundingBox(TimeBoundingBox.ALL_TIMES);
        TimeBoundingBox timeBoundingBox3 = null;
        if (!this.set_timeblocks.isEmpty()) {
            timeBoundingBox3 = (TimeBoundingBox)this.set_timeblocks.last();
        }
        if (timeBoundingBox3 != null && timeBoundingBox3.contains(super.getLatestTime())) {
            timeBoundingBox.setEarliestTime(timeBoundingBox3.getLatestTime());
        } else {
            timeBoundingBox.setEarliestTime(super.getLatestTime());
        }
        this.set_timeblocks.add(timeBoundingBox);
    }

    private void setRealDrawableExclusion() {
        Object[] objectArray = this.set_timeblocks.toArray();
        Stack<Drawable> stack = new Stack<Drawable>();
        Iterator iterator = this.list_nestables.iterator();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            drawable.initExclusion(objectArray);
            while (!stack.empty()) {
                Drawable drawable2 = (Drawable)stack.peek();
                if (drawable2.covers(drawable)) {
                    drawable2.decrementExclusion(drawable.getExclusion());
                    break;
                }
                stack.pop();
            }
            stack.push(drawable);
        }
        stack.clear();
        stack = null;
        objectArray = null;
        this.set_timeblocks.clear();
        this.set_timeblocks = null;
    }

    private void adjustMapOfCategoryWeights() {
        Iterator iterator = this.list_nestables.iterator();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            float f = (float)(drawable.getExclusion() / this.box_duration);
            Category category = drawable.getCategory();
            CategoryWeight categoryWeight = (CategoryWeight)this.map_type2twgt.get(category);
            categoryWeight.addExclusiveRatio(f);
        }
        this.list_nestables.clear();
    }

    public void setNestingExclusion() {
        this.patchSetOfTimeBlocks();
        this.setRealDrawableExclusion();
        this.adjustMapOfCategoryWeights();
    }

    public double getAveNumOfRealObjects() {
        return this.num_real_objs;
    }

    public void initializeCategoryTimeBoxes() {
        if (this.typebox_ary == null) {
            this.typebox_ary = new CategoryTimeBox[this.map_type2twgt.size()];
            int n = 0;
            Iterator iterator = this.map_type2twgt.values().iterator();
            while (iterator.hasNext()) {
                CategoryTimeBox categoryTimeBox;
                CategoryWeight categoryWeight = (CategoryWeight)iterator.next();
                this.typebox_ary[n] = categoryTimeBox = new CategoryTimeBox(categoryWeight);
                ++n;
            }
        }
    }

    public CategoryTimeBox[] arrayOfCategoryTimeBoxes() {
        return this.typebox_ary;
    }

    public TimeBoundingBox getCurrentTimeBoundingBox() {
        if (this.curr_timebox == null) {
            this.curr_timebox = new TimeBoundingBox();
        }
        return this.curr_timebox;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" Nrobjs=" + (float)this.num_real_objs);
        if (this.map_type2twgt.size() > 0) {
            CategoryWeight[] categoryWeightArray = this.map_type2twgt.values().toArray(new CategoryWeight[0]);
            Arrays.sort(categoryWeightArray, CategoryWeight.INCL_RATIO_ORDER);
            int n = categoryWeightArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\n" + categoryWeightArray[i]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

