//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: routecombo.cpp,v 1.1.1.1 2003/10/29 10:05:23 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "node.h"
#include "routecombo.h"
#include <stdio.h>
#include "song.h"
#include "audio.h"
#include "driver/audiodev.h"
#include "globals.h"

#include <qlistbox.h>

//---------------------------------------------------------
//   RouteComboBox
//---------------------------------------------------------

RouteComboBox::RouteComboBox(QWidget* parent, AudioNode* s)
   : QComboBox(false, parent, "route")
      {
      setFont(font1);
      src = s;
      QListBox* lb = new QListBox(this);
      setListBox(lb);
      lb->setFixedWidth(90);
      connect(this, SIGNAL(activated(const QString&)), SLOT(setRoute(const QString&)));
      }

//---------------------------------------------------------
//   setRoute
//---------------------------------------------------------

void RouteComboBox::setRoute(const QString& r)
      {
      AudioNode* dst = name2Node(r);
      if (src == &audioOutput) {
            if (audioDevice)
                  audioDevice->setOutputPort(r);
            }
      else
            audio->msgSetRoute(src, dst);
      song->update(SC_ROUTE);
      }

