/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnudownload.h  -  Definition of a file download in the gnutella network

 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__GNUDOWNLOAD_H_INCLUDED__)
#define __GNUDOWNLOAD_H_INCLUDED__

/////////////////////////////////////////////////////////////////////////////
// MGnuDownload

class MGnuDirector;
class MGnuPreferences;
class MDownFileMng;
class MDownloader;
class MDownloadBuffer;

enum StoreResult{
	SR_Error,      // crtical -- undefined internal error
				   // reaction: transfer should be stopped
	SR_AsyncError, // crtical -- async WriteSeek failed
				   // reaction: transfer should be stopped
	SR_NoMatch,    // crtical -- the file fragment doe not match
				   // reaction: transfer should be stopped
	SR_DiskError,  // less criticall -- no space on the device
				   // reaction: transfer should be stopped
	SR_Stop,       // not critical at all -- Manager thinks transfer has to be interrupted
				   // reaction: transfer should be stopped
	SR_Success     // all fine!
				   // reaction: continue receiving
};

class MEvFileMoved : public TSimpleEvent<CString>{
public:
	MEvFileMoved(const CString& sPath, int nFileSize);
	virtual CString Format();
	int m_nFileSize;
private:
	MEvFileMoved(); // no implementation
};

class MGnuDownload : protected SGnuDownload
{
public:
	MGnuDownload(MGnuDirector*, const ResultVec& results, const CString& sFilename, long nFileHandle);
	virtual ~MGnuDownload();
	MGnuDirector* GetDirector(){return m_pDirector;}
	
	void    Start();
	void    Stop(bool bDeleteFile, bool bDeleteSearch);
	void    OnTimer(int nTimeStamp);
	
	int     LookUp(IP ipHost, const CString& sFileName, int nIndex); // searches the results list and returns the index or -1 if fails
	int     CountActiveConnections(const HOST* pHost);
	int     CountReceivingConnections(const HOST* pHost);
	int     GetNumAlternatives();
	bool    IsPartOf(const CString& path);// returns true if the path points to the partial file of the download
	
	void  GenerateID();
	inline DWORD GetID(){ return m_dwID;}
	
	void    CopyTo(SGnuDownload& copy); // safely copies object into the structure
	
	double  GetRate();
	int     GetStatus(){return m_nStatus;}
	int     DisconnReason();
	DWORD   GetSizeCompleted();
	DWORD   GetSizeReceived();
	
	CString GetFileName();
	void    SetFileName(const CString& sNewName); // does not move the file. in fact it only makes sence to call before "Start()"
	bool    Rename(const CString& sNewName); // renames the partial file, sets new target name and updates automatic search
	
	DWORD   GetSearchID(){return m_dwSearchID;}
	void    SetSearchID(DWORD dwID){m_dwSearchID = dwID;}
	bool    AddSearch(bool bAutoget);
	bool    ShouldDeleteSearch(){return m_bDelSearch;} // internaly used by Director
	
	bool    OnIncomingPush(const CString& sFileName, int nIndex, SOCKET hPushSock); // returns 'true' if the push was accepted

	// rate limiting
	void SetRatePerSocket(long nKbytesPerSec);
	
	// internal use functions
	bool RequestStartPoint(MDownloader* pDownloader); // if returns false caller should close and be ready to go home
	StoreResult StoreDataAt(MDownloader* pDownloader, int nPos, MDownloadBuffer* pBuff, int nSize); // if returns not SR_Success caller should close and be ready to go home
	// internal callbacks
	void OnFileManReady(); // after it's ready RequestStartPoint can be called
	bool OnSetStartPoint(MDownloader* pDownloader, int nFilePos); // return true if start point was accepted
	void OnDataWritten(MDownloader* pDownloader, DWORD dwPos, DWORD dwSize, MDownloadBuffer* pBuff);
	void OnFileError(int nError);
	void OnFileManClosed();
	void OnFileCompleted();
	void OnSegmentCompleted(MDownloader* pDownloader, bool bSuccess); // Downloader should stop here
	// callbacks from MDownloader
	void OnDisconnect(MDownloader* pDownloader); // called by MDownloader when it disconnects being in TRANSFER_RECEIVING status
protected:
	void SetStatus(int nNewStatus);
	void ForceDisconnectAll();
	void UpdateResults();
	MGnuDownload();                          // no implementation
	MGnuDownload(const MGnuDownload& rSrc);  // no implementation
// Implementation
protected:
	MMutex m_mutex;
	//
	vector<Result> m_vecBadResults;
	// good sha1-s, which passed the overlap test
	set<SHA1Hash> m_setSha1;
	bool m_bExactSha1Match;
	// KnownFile database support
	long m_nFileHandle;
	//
	DWORD m_dwSearchID;
	bool  m_bDelSearch;
	//
	DWORD m_dwResumeStartPosition;
	//
	MGnuPreferences* m_pPrefs;
	MGnuDirector*  m_pDirector;
	//
	MDownFileMng* m_pFileMng;
	//
	vector<MDownloader*> m_vecDownloaders;
};

/////////////////////////////////////////////////////////////////////////////

#endif // __GNUDOWNLOAD_H_INCLUDED__

