// commenteditor.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The CommentEditor class is a simple text editor for modifying the text 
// string stored as a comment in Sound, LPC, and FFT data files.  This class
// is general enough that it could be used as an all-purpose text editor if
// there proves need for such a thing in this program.

#ifndef COMMENTEDITOR_H
#define COMMENTEDITOR_H

#ifdef __GNUG__
#pragma interface
#endif

#include <InterViews/texteditor.h>
#include "localdefs.h"

class ButtonState;
class TextBuffer;
class Data;

class CommentEditor : public TextEditor {
public:
    CommentEditor(ButtonState*, Data*);
	virtual ~CommentEditor();
    redefined void Handle(Event&);
	void save();
	void revert();
private:
    void LeftMouse(Event&);
    void HandleDownEvent(Event&);
    void HandleChar(char);
private:
    void Init(ButtonState*);
private:
	Data* myData;
	char* commtext;
    ButtonState* _state;
	TextBuffer* myTextBuffer;
};

#endif
