// cs_pvocheader.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// This class uses the header format for phase vocoder data generated by
// the pvanal routines in Csound.

#ifndef CSPVOCHEADER_H
#ifdef __GNUG__
#pragma interface
#endif
#define CSPVOCHEADER_H

#include "header.h"

class CS_PvocHeader : public FrameDataHeader {
	typedef FrameDataHeader Super;
public:
	CS_PvocHeader(int chans, double frate, int srate);
	virtual ~CS_PvocHeader() {}
protected:
	redefined int diskHeaderSize() { return sizeof(DiskHeader); }
	redefined int diskHeaderCommentSize() { return 4; }
	redefined boolean isMagic() { return magic() == PV_MAGIC; }
	redefined int checkHeader();
	redefined int readInfo(DataFile *);
	redefined int writeInfo(DataFile *);
	redefined const char* magicError();
private:
	enum Magic { PV_MAGIC = 517730 };
	enum FrameFormat {
		PVMAG = 1, PVPHASE, PVPOLAR, PVREAL, PVIMAG, PVRECT, PVPVOC,
		PVCQ = 32	// ORed with previous to indicate one frame per 8ve
	};
	enum FreqFormat { PVLIN = 1, PVEXP };
	enum DataFormat {
		PVSHORT = 2,		// 16 bit linear data
		PVLONG = 4,			// 32 bit linear data
		PVFLOAT = (4+32),	// 32 bit float data
		PVDOUBLE = (8+32)	// 64 bit float data
	};
	// The structure of the CS_PVOC header on disk
	struct DiskHeader {
		int	magic;			// magic number to identify
		int	headBsize;		// byte offset from start to data
		int	dataBsize;		// number of bytes of data
		int	dataFormat;	    // (int) format specifier
		float	samplingRate;	// of original sample
		int	channels;		// (int) mono/stereo etc
		int 	frameSize;		// size of FFT frames (2^n)
		int	frameIncr;		// # new samples each frame
		int	frameBsize;		// bytes in each file frame
		int	frameFormat;	// (int) how words are org'd in frms
		float	minFreq;		// freq in Hz of lowest bin (exists)
		float	maxFreq;		// freq in Hz of highest (or next)
		int	freqFormat;		// (int) flag for log/lin frq
		char	info[4];		// extendable byte area
	};
	friend Header* createPvocHeader(class PvocData *, DataFile *);
	friend void	   swapDiskHeader(DiskHeader *);
};

#endif
