#include "mainwindow.h"
#include "mdiwindow.h"
#include "script.h"
#include "edit.h"
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qpixmap.h>

void MainWindow::slot_script()
{
	MDIWindow* s = new MDIWindow(workspace, 0, WDestructiveClose);

	Script *script = new Script(&mysql, s);

	connect(script, SIGNAL(signal_schema()), this, SLOT(slot_schema()));

    s->setCentralWidget(script);
			 
    s->setCaption(tr("Script"));

	QPopupMenu *z= new QPopupMenu();
	z->insertItem(tr("&Open"), script, SLOT(slot_script()));
	z->insertItem(tr("&Fire"), script, SLOT(slot_fire()), Key_F5);
	z->insertSeparator();	
	z->insertItem(tr("Cl&ose"), script, SLOT(slot_close()));
	s->menuBar()->insertItem(tr("&File"), z);

	z = new QPopupMenu();
	//z->insertItem(tr("Cl&ear Query"), script, SLOT(slot_clear()));
	z->insertItem(tr("Select &All"), script, SLOT(slot_select_all()));
	z->insertItem(tr("Select &None"), script, SLOT(slot_select_none()));
	s->menuBar()->insertItem(tr("&Tools"), z);

	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), script, SLOT(slot_about()), Key_F1);
	//s->menuBar()->insertItem(tr("&Help"), z);

	s->resize(444,200);
	
	s->show();
}

void MainWindow::slot_edit()
{
	Edit *edit = new Edit(workspace,0,WDestructiveClose);

	if(option.xpm)
		edit->slot_xpm(option.xpm);
	else
		edit->slot_xpm("");

	connect(this, SIGNAL(signal_xpm(const QString &)), edit, SLOT(slot_xpm(const QString &)));

	edit->setCaption(tr("Edit"));
	edit->resize(500,400);	
	edit->show();
}
