#ifndef QUERYLISTVIEW_H
#define QUERYLISTVIEW_H

#include <qlistview.h>
#include <qstatusbar.h>
#include <qmap.h>
#include <qmenubar.h>
#include <mysql.h>

#define SQL_ERROR		-1
#define SQL_NOSCHEMA	0
#define SQL_SCHEMA		1	
#define SQL_SIMPLE		2		
#define SQL_UPDATE	3

#define FLAG_NONE	0
#define FLAG_NUMBER	1
#define FLAG_STRING	2

#include "mainwindowoption.h"

class QueryListView : public QListView
{
Q_OBJECT

public:
	QueryListView(QMenuBar *, QStatusBar *, MYSQL *,struct __option__ *, QWidget *);
	~QueryListView();

	void set_sql(const QString &, const QString &, const QString &table = "");
	int execute(bool flag = TRUE);
	bool is_select();

public slots:
	void slot_clear();
	void slot_close();
	void slot_save();
	void slot_about();
	void slot_sort(int);
	void slot_option();
	void slot_reload();

private:
	QString database;
	QString sql;
	QString table;	
	MYSQL *mysql;
	MYSQL_RES *result;
	MYSQL_ROW row; 
	MYSQL_FIELD *field;
	bool escape;	
	QMap<unsigned int, int> type;
	// key: index, value: type
	QListViewItem *hay;
	struct __option__ *option;
	QStatusBar *statusbar;
	QMenuBar *menubar;

	QString get_table();
	QListViewItem *get_last();
	bool get_primary();
	bool can_modify();
	QMap<QString, int> key;
	QMap<int, bool> sort;

signals:
	void signal_query(const QString &, const QString &);

private:
	void signal_connect();

private slots:
	void slot_click(QListViewItem *, const QPoint &, int);
	void slot_delete(int);
	void slot_insert(int);
	void slot_update(int);
	void slot_sql_success();
	void slot_select_all(int);
	void slot_select_none(int);
};

#endif
