unit CommonFuncs;

interface

uses
  gnugettext, SysUtils, Options, AuxFuncs, Windows, Forms, About;

procedure CheckCommonCommandlineParameter;
procedure ShowAboutDialog(Caption: WideString;
  Version: WideString; Credits: WideString);

implementation

procedure CheckCommonCommandlineParameter;

var
  i: integer;
  S: string;
  
begin
  for i := 1 to ParamCount do
  begin
    //-------------------------------------------------------------
    //General cmdline parameters

    s := ParamStr(I);
    //Connection
    if (Copy(S, 1, 2) = '-c') then
      MYXCommonOptions.ConnectionToUse := Copy(ParamStr(i), 3, Length(ParamStr(i)));

    //Username
    if (Copy(S, 1, 2) = '-u') then
      MYXCommonOptions.ConnectionUsername := Copy(ParamStr(i), 3, Length(ParamStr(i)));
    //Password
    if (Copy(S, 1, 2) = '-p') then
      MYXCommonOptions.ConnectionPassword := Copy(ParamStr(i), 3, Length(ParamStr(i)));
    //Host
    if (Copy(S, 1, 2) = '-h') then
      MYXCommonOptions.ConnectionHost := Copy(ParamStr(i), 3, Length(ParamStr(i)));
    //Port
    if (Copy(S, 1, 2) = '-P') then
      MYXCommonOptions.ConnectionPort := Copy(ParamStr(i), 3, Length(ParamStr(i)));
    //Schema
    if (Copy(S, 1, 2) = '-D') then
      MYXCommonOptions.ConnectionSchema := Copy(ParamStr(i), 3, Length(ParamStr(i)));
  end;

  //If only username was specified, automaticly set
  //other connection values
  if (MYXCommonOptions.ConnectionUsername <> '') then
  begin
    if (MYXCommonOptions.ConnectionHost = '') then
      MYXCommonOptions.ConnectionHost := 'localhost';

    if (MYXCommonOptions.ConnectionPort = '') then
      MYXCommonOptions.ConnectionPort := '3306';
  end;
end;

procedure ShowAboutDialog(Caption: WideString;
  Version: WideString; Credits: WideString);
var
  AboutForm: TAboutForm;
begin
  AboutForm := TAboutForm.Create(nil);
  try
    AboutForm.Caption := _('About ') + Caption;
    AboutForm.VersionLbl.Caption := _('version') + ' ' + Version;
    AboutForm.TextLbl.Caption := Credits;
    AboutForm.ShowModal;
  finally
    AboutForm.Free;
  end;
end;

end.

