#
# This script was written by Michael Scheidell <scheidell at secnap.net>
#
# See the Nessus Scripts License for details
#
#
# Also supercedes MS02-005, MS02-047, MS02-027, MS02-023, MS02-015, MS01-015
#
# 

if(description)
{
 script_id(10861);
 script_bugtraq_id(11388, 11385, 11383, 11381, 11377, 11367, 11366);
 if ( NASL_LEVEL >= 2191 ) script_bugtraq_id(10473, 8565, 9009, 9012, 9013, 9014, 9015, 9182, 9663, 9798, 12477, 12475, 12473);
 script_version("$Revision: 1.55 $");
 script_cve_id("CAN-2004-0842", "CAN-2004-0727", "CAN-2004-0216", "CAN-2004-0839", "CAN-2004-0844", "CAN-2004-0843", "CAN-2004-0841", "CAN-2004-0845");
 if ( NASL_LEVEL >= 2191 ) script_cve_id("CAN-2003-0814", "CAN-2003-0815", "CAN-2003-0816", "CAN-2003-0817", "CAN-2003-0823", "CAN-2004-0549", "CAN-2004-0566", "CAN-2003-1048", "CAN-2001-1325", "CAN-2001-0149", "CAN-2001-0727", "CAN-2001-0875", "CVE-2001-1325", "CVE-2001-0149", "CVE-2001-0727", "CVE-2001-0875", "CVE-2001-0339", "CVE-2001-0002", "CAN-2002-0190", "CVE-2002-0026", "CAN-2003-1326", "CVE-2002-0027", "CVE-2002-0022", "CAN-2003-1328", "CAN-2002-1262", "CAN-2002-0193", "CAN-1999-1016", "CVE-2003-0344", "CAN-2003-0233", "CAN-2003-0309", "CAN-2003-0113", "CAN-2003-0114", "CAN-2003-0115", "CAN-2003-0116", "CAN-2003-0531", "CAN-2003-0809", "CAN-2003-0530", "CAN-2003-1025", "CAN-2003-1026", "CAN-2003-1027");
 if(defined_func("script_xref"))script_xref(name:"IAVA", value:"2003-A-0014");
 if(defined_func("script_xref"))script_xref(name:"IAVA", value:"2004-A-0016");
 name["english"] = "IE 5.01 5.5 6.0 Cumulative patch (867282)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The July 2004 Cumulative Patch for IE is not applied on the remote host.

Impact of vulnerability: Run code of attacker's choice. 

Recommendation: Customers using IE should install the patch immediately. 

Affected Software: 

Microsoft Internet Explorer 5.01 (SP3 required to install)
Microsoft Internet Explorer 5.5 (SP2 required to install)
Microsoft Internet Explorer 6.0 

NOTE: Might require full registry access on win2k, xp and Server 2003

Supersedes MS01-055, MS01-058, MS02-005, MS02-066, MS02-068, MS03-004, 
MS03-014, MS03-015, MS03-020, MS03-032, MS03-040, MS03-048, MS04-004,
MS04-025, MS04-038 and others.

See http://www.microsoft.com/technet/security/bulletin/ms05-014.mspx
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines whether the hotfix 867282 is installed";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michael Scheidell");
 family["english"] = "Windows : Microsoft Bulletins";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/registry_full_access");
 script_require_ports(139, 445);
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


include("smb_nt.inc");
include("smb_hotfixes.inc");

#sp = get_kb_item("SMB/WinXP/ServicePack");
#if(sp && ereg(pattern:"Service Pack [2-9]", string:sp))exit(0);

access = get_kb_item("SMB/registry_full_access");
if(!access)exit(0);

port = get_kb_item("SMB/transport");
if(!port)port = 139;


version = get_kb_item("SMB/WindowsVersion");

if(version)
{
 key = "SOFTWARE\Microsoft\Internet Explorer\Version Vector";
 item = "IE";
 value = string(registry_get_sz(key:key, item:item));

 if(!value)
 {
   exit(0);
 }

 report = string("We were able to determine that you are running IE Version ",value);
 
 key =  "SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings";
 item = "MinorVersion";
 minorversion = string(registry_get_sz(key:key, item:item));

 if(minorversion)
 {
    report = report + string("\nwith these IE Hotfixes installed:",minorversion);

 missing = NULL;

 if ( hotfix_missing(name:"867282.*") == 0 ) exit(0); 

 if ( "867282" >!< minorversion ) missing += "867282 (MS05-014)";
# if("Q824145" >!< minorversion)missing += "Q824145 (MS03-048) ";
# if("Q828750" >!< minorversion)missing += "Q828750 (MS03-040) ";
# if("822925" >!< minorversion) missing += "Q822925 (MS03-032) ";
# if("Q818529" >!< minorversion)missing += "Q818529 (MS03-020) ";
# if("Q813489" >!< minorversion)missing += "Q813489 (MS03-015) ";
# if("Q330994" >!< minorversion)missing += "Q330994 (MS03-014) ";
 }
 else if ( hotfix_missing(name:"867282.*") > 0 ) 
  missing += "867282 (MS05-014)";


 if( missing )
   {
    report = report + string("\n
But is missing security update(s) ", missing, "
Recommendation: Customers using Microsoft IE  should install
this patch immediately. 

Impact of vulnerability: Run code of attacker's choice. 

See http://www.microsoft.com/technet/security/bulletin/ms05-014.mspx

Supersedes MS01-055, MS01-058, MS02-005, MS02-066, MS02-068, MS03-004, 
MS03-014, MS03-015, MS03-020, MS03-032, MS03-040, MS03-048, MS04-004,
MS04-025, MS04-038 and others.

Risk factor : High");

   security_hole(port:port, data:report);
  }
 #else
 #  security_note(port:port, data:report);
}

