

from twisted.application import service, internet
from twisted.cred import portal, checkers, credentials

from nevow import appserver, guard, liveevil

import chatola


realm = chatola.ChatolaRealm()
portal = portal.Portal(realm)
portal.registerChecker(checkers.AllowAnonymousAccess(), credentials.IAnonymous)

site = appserver.NevowSite(
    guard.SessionWrapper(portal, mindFactory=liveevil.LiveEvil)
)

application = service.Application("chatola")
internet.TCPServer(8080, site).setServiceParent(application)
