# Copyright 2003 Ruven Pillay
# Distributed under the terms of the GNU General Public License v2
# $Header: $

DESCRIPTION="VIPS Image Processing Graphical User Interface"
SRC_URI="http://www.vips.ecs.soton.ac.uk/vips-7.9/${P}.tar.gz"
HOMEPAGE="http://vips.sourceforge.net"

SLOT="0"
LICENSE="GPL-2"

KEYWORDS="x86 ~ppc ~sparc ~alpha ~arm ~hppa"

IUSE="fftw"

RDEPEND=">=media-libs/vips-7.10.0
        >=x11-libs/gtk+-2.4.*
        libxml2
        >=dev-libs/glib-2*
	fftw? ( =dev-libs/fftw-2* )"

# Flex is a build dependency, but is not needed at runtime
DEPEND="${RDEPEND}
	bison
	flex"

src_compile() {
	local myconf
	use fftw || myconf="--without-fftw"
        econf ${myconf} || die
        emake || die
}

src_install() {
        einstall || die
}
