/* All ip headers.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* Turn off VIPS's old and broken defines, we don't need them.
 */
#define IM_NO_VIPS7_COMPAT

/* Enable heap sanity checks on every alloc ... very slow ... also see heap.c
#define DEBUG_HEAP
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#ifdef ENABLE_NLS
#include <libintl.h>
#define _(String) gettext(String)
#ifdef gettext_noop
#define N_(String) gettext_noop(String)
#else
#define N_(String) (String)
#endif
#else /* NLS is disabled */
#define _(String) (String)
#define N_(String) (String)
#define textdomain(String) (String)
#define gettext(String) (String)
#define dgettext(Domain,String) (String)
#define dcgettext(Domain,String,Type) (String)
#define bindtextdomain(Domain,Directory) (Domain) 
#define bind_textdomain_codeset(Domain,Codeset) (Codeset) 
#define ngettext(S, P, N) ((N) == 1 ? (S) : (P))
#endif /* ENABLE_NLS */

#include <assert.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <math.h>
#include <memory.h>
#include <locale.h>
#include <setjmp.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_PWD_H
#include <pwd.h>
#endif /*HAVE_PWD_H*/
#ifdef HAVE_FNMATCH_H
#include <fnmatch.h>
#endif /*HAVE_FNMATCH_H*/
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif /*HAVE_SYS_PARAM_H*/
#include <sys/stat.h>
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif /*HAVE_SYS_TIME_H*/
#include <sys/types.h>
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif /*HAVE_SYS_RESOURCE_H*/
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif /*HAVE_SYS_WAIT_H*/
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /*HAVE_UNISTD_H*/
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif /*HAVE_REGEX_H*/
#ifdef HAVE_SYS_STATVFS_H
#include <sys/statvfs.h>
#endif /*HAVE_SYS_STATVFS_H*/
#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
extern int statfs();
#endif /*HAVE_SYS_VFS_H*/
#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif /*HAVE_SYS_MOUNT_H*/
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#endif /*HAVE_WINDOWS_H*/
#ifdef HAVE_FFTW
#include <fftw.h>
#endif /*HAVE_FFTW*/
#ifdef HAVE_FFTW3
#include <fftw3.h>
#endif /*HAVE_FFTW3*/
#include <fcntl.h>

/* Have to include glib before dmalloc ... dmalloc may be included by vips.h
 */
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <vips/vips.h>
#include <vips/history.h>
#include <vips/time.h>

#include <libxml/tree.h>
#include <libxml/parser.h>

/* Our general widgets.
 */
#include "formula.h"
#include "orderitem.h"
#include "orderlist.h"
#include "led.h"
#include "doubleclick.h"

/* Generated marshallers.
 */
#include "nipmarshal.h"

#define MAXFILES (4000)		/* Max. no of files in path */
#define STACK_SIZE (1000)	/* Depth of eval stack */
#define LEN_LABEL (512)		/* Label on windows */
#define MAX_SYSTEM (50)		/* Max number of args we allow */
#define MAX_BANDS (64)		/* Max number of bands in image */
#define MAX_CSTACK (10)		/* Max number of cursors we stack */
#define MAX_STRSIZE (32768)	/* Size of text for user defs */
#define MAX_TRACE (1024)	/* Biggest thing we print in trace */
#define MAX_SSTACK (40)		/* Scope stack for parser */
#define VIPS_HOMEPAGE "http://www.vips.ecs.soton.ac.uk"
#define NIP_DOCPATH "$VIPSHOME" IM_DIR_SEP_STR "share" IM_DIR_SEP_STR \
	"doc" IM_DIR_SEP_STR PACKAGE IM_DIR_SEP_STR "html"
#define VIPS_DOCPATH "$VIPSHOME" IM_DIR_SEP_STR "share" IM_DIR_SEP_STR \
	"doc" IM_DIR_SEP_STR "vips" IM_DIR_SEP_STR "html"
#define IP_NAME PACKAGE "-" VERSION
#define NAMESPACE VIPS_HOMEPAGE "/" "nip" 
				/* XML namespace ... note, not nip2! */
#define MAX_LINELENGTH (120)	/* Max chars we display of value */
#define MAX_RECENT (10)		/* Number of recent items in file menu */

/* Our stock_ids.
 */
#define STOCK_DROPPER "nip-dropper"
#define STOCK_DUPLICATE "nip-duplicate"
#define STOCK_PAINTBRUSH "nip-paintbrush"
#define STOCK_LINE "nip-linedraw"
#define STOCK_TEXT "nip-text"
#define STOCK_SMUDGE "nip-smudge"
#define STOCK_FLOOD "nip-flood"
#define STOCK_FLOOD_BLOB "nip-floodblob"
#define STOCK_RECT "nip-rect"
#define STOCK_MOVE "nip-move"
#define STOCK_SELECT "nip-select"

/* How much we decompile for error messages.
 */
#define MAX_ERROR_FRAG (100)

/* Handle broken mkdirs()
 */
#if HAVE_MKDIR
# if MKDIR_TAKES_ONE_ARG
   /* Mingw32 */
#  define mkdir(a,b) mkdir(a)
# endif
#else
# ifdef HAVE__MKDIR
   /* plain Win32 */
#  include <direct.h>
#  define mkdir(a,b) _mkdir(a)
# else
#  error "Don't know how to create a directory on this system."
# endif
#endif

/* win32 adds '_'.
 */
#ifdef HAVE_WINDOWS_H
#define popen(b,m) _popen(b,m)
#define pclose(f) _pclose(f)
#define mktemp(f) _mktemp(f)
#endif

/* Fwd ref these.
 */
typedef struct _Watch Watch;
typedef struct _Toolitem Toolitem;
typedef struct _BuiltinInfo BuiltinInfo;
typedef struct _Classmodel Classmodel;
typedef struct _Colour Colour;
typedef struct _Column Column;
typedef struct _Columnview Columnview;
typedef struct _Compile Compile;
typedef struct _Conversion Conversion;
typedef struct _Conversionview Conversionview;
typedef struct _Expr Expr;
typedef struct _Filemodel Filemodel;
typedef struct _Heap Heap;
typedef struct _HeapBlock HeapBlock;
typedef struct _Heapmodel Heapmodel;
typedef struct _iArrow iArrow;
typedef struct _iImage iImage;
typedef struct _Imagedisplay Imagedisplay;
typedef struct _Imageinfo Imageinfo;
typedef struct _Imagepresent Imagepresent;
typedef struct _Imagemodel Imagemodel;
typedef struct _iRegion iRegion;
typedef struct _iRegiongroup iRegiongroup;
typedef struct _Link Link;
typedef struct _LinkExpr LinkExpr;
typedef struct _Model Model;
typedef struct _iObject iObject;
typedef struct _iContainer iContainer;
typedef struct _Paintboxview Paintboxview;
typedef struct _ParseConst ParseConst;
typedef struct _ParseNode ParseNode;
typedef struct _Program Program;
typedef struct _String String;
typedef struct _Number Number;
typedef struct _Reduce Reduce;
typedef struct _Regionview Regionview;
typedef struct _Rhs Rhs;
typedef struct _Rhsview Rhsview;
typedef struct _Row Row;
typedef struct _Rowview Rowview;
typedef struct _Statusview Statusview;
typedef struct _Subcolumn Subcolumn;
typedef struct _Subcolumnview Subcolumnview;
typedef struct _Symbol Symbol;
typedef struct _Tool Tool;
typedef struct _Toolkit Toolkit;
typedef struct _Toolkitgroup Toolkitgroup;
typedef struct _Toolkitgroupview Toolkitgroupview;
typedef struct _Toolkitview Toolkitview;
typedef struct _Toolview Toolview;
typedef struct _Trace Trace;
typedef struct _vObject vObject;
typedef struct _View View;
typedef struct _Workspace Workspace;
typedef struct _Workspacegroup Workspacegroup;
typedef struct _Workspacegroupview Workspacegroupview;
typedef struct _Workspaceview Workspaceview;
typedef struct _iText iText;
typedef struct _Expression Expression;
typedef struct _Mainw Mainw;
typedef struct _Toolviewitemgroup Toolviewitemgroup;

/* container map function typedefs.
 */
typedef void *(*row_map_fn)( Row *, void *, void *, void * );
typedef void *(*symbol_map_fn)( Symbol *, void *, void *, void * );
typedef void *(*column_map_fn)( Column *, void * );
typedef void *(*view_map_fn)( View *, void *, void * );
typedef void *(*rowview_map_fn)( Rowview *, void * );
typedef void *(*workspace_map_fn)( Workspace *, void * );
typedef void *(*toolkit_map_fn)( Toolkit *, void *, void * );
typedef void *(*tool_map_fn)( Tool *, void *, void * );

/* Util stuff.
 */
#include "gtkutil.h"
#include "util.h"
#include "wild.h"
#include "path.h"
#include "iobject.h"
#include "icontainer.h"
#include "iwindow.h"
#include "idialog.h"
#include "boxes.h"
#include "filesel.h"
#include "imageinfo.h"
#include "imagedisplay.h"
#include "colourdisplay.h"
#include "imagemodel.h"
#include "imagepresent.h"
#include "imageview.h"
#include "tslider.h"

/* Basic ip includes (order important).
 */
#include "tree.h"
#include "heap.h"
#include "class.h"
#include "link.h"
#include "expr.h"
#include "model.h"
#include "paintboxview.h"
#include "conversion.h"
#include "heapmodel.h"
#include "classmodel.h"
#include "filemodel.h"
#include "symbol.h"
#include "workspace.h"
#include "workspacegroup.h"
#include "toolkitgroup.h"
#include "secret.h"
#include "action.h"
#include "reduce.h"
#include "vobject.h"
#include "view.h"
#include "graphicview.h"
#include "spin.h"
#include "row.h"
#include "rowview.h"
#include "subcolumn.h"
#include "subcolumnview.h"
#include "rhs.h"
#include "rhsview.h"
#include "workspaceview.h"
#include "toolkitgroupview.h"
#include "column.h"
#include "columnview.h"
#include "toolkit.h"
#include "tool.h"
#include "toolkitview.h"
#include "toolview.h"
#include "watch.h"

/* Per module includes, any order
 */
#include "toolkitbrowser.h"
#include "trace.h"
#include "program.h"
#include "conversionview.h"
#include "statusview.h"
#include "mainw.h"
#include "browse.h"
#include "builtin.h"
#include "compile.h"
#include "dump.h"
#include "graph.h"
#include "main.h"
#include "predicate.h"
#include "slider.h"
#include "pathname.h"
#include "fontname.h"
#include "group.h"
#include "colour.h"
#include "number.h"
#include "istring.h"
#include "editview.h"
#include "expression.h"
#include "expressionview.h"
#include "stringview.h"
#include "numberview.h"
#include "matrix.h"
#include "matrixview.h"
#include "option.h"
#include "optionview.h"
#include "iimage.h"
#include "iregion.h"
#include "iregiongroup.h"
#include "iarrow.h"
#include "iarrowview.h"
#include "sliderview.h"
#include "pathnameview.h"
#include "fontnameview.h"
#include "groupview.h"
#include "colourview.h"
#include "iimageview.h"
#include "iregionview.h"
#include "iregiongroupview.h"
#include "prefs.h"
#include "regionview.h"
#include "itext.h"
#include "itextview.h"
#include "toggle.h"
#include "toggleview.h"
#include "vips_call.h"

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Default show states.
 */
#define DISPLAY_RULERS \
	(watch_bool_get( main_watchgroup, "DISPLAY_RULERS", FALSE ))
#define DISPLAY_STATUS \
	(watch_bool_get( main_watchgroup, "DISPLAY_STATUS", FALSE ))
#define DISPLAY_CONVERT \
	(watch_bool_get( main_watchgroup, "DISPLAY_CONVERSION", FALSE ))

/* Update children during paint.
 */
#define PAINTBOX_RECOMP \
	(watch_bool_get( main_watchgroup, "PAINTBOX_RECOMP", TRUE ))

/* Help browser.
 */
#define BOX_BROWSER (watch_string_get( main_watchgroup, "BROWSER", "mozilla" ))
#define BOX_BROWSER_REMOTE (watch_string_get( main_watchgroup, \
	"BROWSER_REMOTE", "-remote 'openURL(%s)'" ))

/* Thumbnail size.
 */
#define DISPLAY_THUMBNAIL \
	(watch_int_get( main_watchgroup, "DISPLAY_THUMBNAIL", 64 ))

/* File stuff.
 */
#define PIN_FILESEL \
	(watch_bool_get( main_watchgroup, "CALC_PIN_FILESEL", FALSE ))
#define IP_JPEG_Q \
	(watch_int_get( main_watchgroup, "JPEG_Q", 75 ))
#define IP_PPM_MODE \
	(watch_int_get( main_watchgroup, "PPM_MODE", 0 ))
#define IP_PNG_COMPRESSION \
	(watch_int_get( main_watchgroup, "PNG_COMPRESSION", 6 ))
#define IP_PNG_INTERLACE \
	(watch_int_get( main_watchgroup, "PNG_INTERLACE", 0 ))
#define IP_TIFF_COMPRESSION \
	(watch_int_get( main_watchgroup, "TIFF_COMPRESSION", 0 ))
#define IP_TIFF_JPEG_Q \
	(watch_int_get( main_watchgroup, "TIFF_JPEG_Q", 75 ))
#define IP_TIFF_LAYOUT \
	(watch_int_get( main_watchgroup, "TIFF_LAYOUT", 0 ))
#define IP_TIFF_TILE_WIDTH \
	(watch_int_get( main_watchgroup, "TIFF_TILE_WIDTH", 128 ))
#define IP_TIFF_TILE_HEIGHT \
	(watch_int_get( main_watchgroup, "TIFF_TILE_HEIGHT", 128 ))
#define IP_TIFF_MULTI_RES \
	(watch_int_get( main_watchgroup, "TIFF_MULTI_RES", 0 ))
#define IP_TIFF_FORMAT \
	(watch_int_get( main_watchgroup, "TIFF_FORMAT", 0 ))

/* Autoreload. 
 */
#define CALC_RELOAD (watch_bool_get( main_watchgroup, "CALC_RELOAD", FALSE ))

/* Max chars we print. Limit to MAX_LINELENGTH to stop out-of-control stuff.
 */
#define LINELENGTH \
	(IM_MIN( MAX_LINELENGTH, \
		watch_int_get( main_watchgroup, "CALC_LINELENGTH", 80 ) ))

/* CPUs we work over.
 */
#define VIPS_CPUS \
	(watch_int_get( main_watchgroup, "VIPS_CPUS", 1 ))

/* Bar prefs.
 */
#define MAINW_TOOLBAR \
	(watch_bool_get( main_watchgroup, "MAINW_TOOLBAR", TRUE ))
#define MAINW_TOOLBAR_STYLE \
	(watch_int_get( main_watchgroup, "MAINW_TOOLBAR_STYLE", 0 ))
#define MAINW_STATUSBAR \
	(watch_bool_get( main_watchgroup, "MAINW_STATUSBAR", TRUE ))
#define MAINW_TOOLKITBROWSER \
	(watch_bool_get( main_watchgroup, "MAINW_TOOLKITBROWSER", FALSE ))
#define MAINW_PANE_POSITION \
	(watch_int_get( main_watchgroup, "MAINW_PANE_POSITION", 400 ))

/* Heap size.
 */
#define MAX_HEAPSIZE (watch_int_get( main_watchgroup, "CALC_MAX_HEAP", 200000 ))

/* Region dragging.
 */
#ifdef NO_UPDATE
#define CALC_RECOMP_REGION \
	(watch_bool_get( main_watchgroup, "CALC_RECOMP_REGION", FALSE ))
#else
#define CALC_RECOMP_REGION \
	(watch_bool_get( main_watchgroup, "CALC_RECOMP_REGION", TRUE ))
#endif

/* Slider dragging.
 */
#define CALC_RECOMP_SLIDER \
	(watch_bool_get( main_watchgroup, "CALC_RECOMP_SLIDER", FALSE ))

/* Popup new objects.
 */
#define POPUP_NEW_ROWS \
	(watch_bool_get( main_watchgroup, "POPUP_NEW_ROWS", FALSE ))

/* Draw LEDs rather than recolouring tally buttons.
 */
#define CALC_DISPLAY_LED \
	(watch_bool_get( main_watchgroup, "CALC_DISPLAY_LED", FALSE ))

/* Autorecomp.
 */
#define CALC_RECOMP (watch_bool_get( main_watchgroup, "CALC_RECOMP", TRUE ))

/* Number of vips calls to memoise.
 */
#define VIPS_HISTORY_MAX \
	(watch_int_get( main_watchgroup, "VIPS_HISTORY_MAX", 200 ))

/* Auto save wses.
 */
#define AUTO_WS_SAVE \
	(watch_bool_get( main_watchgroup, "CALC_AUTO_WS_SAVE", TRUE ))

/* Image window geometry.
 */
#define IMAGE_WINDOW_WIDTH \
	(watch_int_get( main_watchgroup, "IMAGE_WINDOW_WIDTH", 600 ))
#define IMAGE_WINDOW_HEIGHT \
	(watch_int_get( main_watchgroup, "IMAGE_WINDOW_HEIGHT", 650 ))

/* Default font.
 */
#define PAINTBOX_FONT \
	(watch_string_get( main_watchgroup, "PAINTBOX_FONT", "Sans 12" ))

/* Max undo steps ... -1 == unlimited.
 */
#define PAINTBOX_MAX_UNDO \
	(watch_int_get( main_watchgroup, "PAINTBOX_MAX_UNDO", -1 ))

/* Default image file type.
 */
#define IMAGE_FILE_TYPE \
	(watch_int_get( main_watchgroup, "IMAGE_FILE_TYPE", 0 ))

/* Prefs we watch.
 */
#define PATH_SEARCH (watch_path_get( main_watchgroup, "CALC_PATH_SEARCH", \
	path_search_default ))
#define PATH_START (watch_path_get( main_watchgroup, "CALC_PATH_START", \
	path_start_default ))
#define PATH_TMP (watch_string_get( main_watchgroup, "CALC_PATH_TMP", \
	path_tmp_default ))

/* Disassemble functions.
 */
#define TRACE_FUNCTIONS \
	(watch_bool_get( main_watchgroup, "CALC_TRACE_FUNCTIONS", FALSE ))

/* Program window.
 */
#define PROGRAM_PANE_POSITION \
	(watch_double_get( main_watchgroup, "PROGRAM_PANE_POSITION", 200 ))

/* Global variables from parse.y.

	FIXME move to its own header ... parser.h?

 */

/* Our input stream can be attached to either a string or a FILE. 
 * Keep track of the state of play here.
 */
typedef struct {
	iOpenFile *of;		/* Non-NULL if we read from a file */
	char *str;		/* Non-NULL if we read from a string */
	char *strpos;		/* Position in string */

	char buf[MAX_STRSIZE];	/* Accumulate text of each definition here */
	int bwp;		/* Write point in the above */
	int bsp[MAX_SSTACK];	/* Start point stack */
	int bspsp;		/* Stack pointer */

	int lineno;		/* Current line number */
	int charno;		/* Character in line */
	int pcharno;		/* Characters in previous line */
	int charpos;		/* Characters read by lex so far */

	int oldchar;            /* unget buffer, -1 for no unget */
} InputState;

extern InputState input_state;

/* Function declarations for parse.y.
 */
void yyerror( const char *sub, ... );	
extern int yyleng;			/* lex stuff */

/* Lex gathers tokens here for workspace.c
 */
extern BufInfo lex_text;

/* Attach input for lex.
 */
void attach_input_file( iOpenFile *of );
void attach_input_string( const char *str );
int ip_input( void );
void ip_unput( int ch );
gboolean is_EOF( void );

/* Parse stuff.
 */

/* Order and number important ... see table in parse_rhs()
 */
typedef enum {
	PARSE_RHS = 0,		/* eg. "a + b" */
	PARSE_PARAMS,		/* eg. "a b = a + b" */
	PARSE_SUPER 		/* eg. "fred c d" */
} ParseRhsSyntax;

gboolean parse_toplevel( Toolkit *kit, int pos );
gboolean parse_onedef( Toolkit *kit, int pos );
gboolean parse_rhs( Expr *expr, ParseRhsSyntax syntax );

extern Symbol *last_top_sym;

