/*
  filter: runs standard utilities, such as grep(1), sed(1), etc.,
  on a NoSQL table passed via STDIN.

  Copyright (c) 2001,2002,2003 Carlo Strozzi

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  $Id: filter.c,v 1.5 2003/10/09 10:53:30 carlo Exp $

*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/file.h>

#ifndef HELPDIR
#define HELPDIR "/usr/local/nosql/help"
#endif
#ifndef HELPFILE
#define HELPFILE (HELPDIR "/filter.txt")
#endif

/* Unbuffered input routine */

static int getch(void) {
	char c;
	return (read(0, &c, 1) == 1) ? (unsigned char) c : EOF;
}

static int eusage(void) {
	fputs("Usage: filter [options --] command [args]\n", stderr);
	return 1;
}

int main(int argc, char *argv[]) {

	int i = 0, c, no_hdr = 0, min_args = 2;

	FILE *ifile = NULL, *ofile = NULL;

	while (++i < argc && *argv[i] == '-') {

		min_args++;

		if (!strcmp(argv[i], "--")) {
			i++;
			break;
		}

		else if (!strcmp(argv[i], "-N") ||
		    	 !strcmp(argv[i], "--no-header")) no_hdr = 1;

		else if (!strcmp(argv[i], "-i") ||
			 !strcmp(argv[i], "--input")) {

			if (++i >= argc || *argv[i] == '-') exit(eusage());

			min_args++;

			if ((ifile = freopen(argv[i], "r", stdin)) < 0) {
				perror(argv[i]);
				exit(1);
			}
		}

		else if (!strcmp(argv[i], "-o") ||
			 !strcmp(argv[i], "--output")) {

			if (++i >= argc || *argv[i] == '-') exit(eusage());

			min_args++;

			if ((ofile = freopen(argv[i], "w", stdout)) < 0) {
				perror(argv[i]);
				exit(1);
			}
		}

		else if (!strcmp(argv[i], "-h") ||
			 !strcmp(argv[i], "--help")) {

			execlp("grep","grep","-v","^#",HELPFILE,(char *) 0);
			perror("grep");
			exit(0);
		}
	}

	if (argc < min_args) exit(eusage());

	while ((c = getch()) != EOF) {
		if (!no_hdr) putchar(c);
		if (c == '\n') {
			fflush(NULL);	/* Make sure the header is output */
			execvp(argv[i], &argv[i]);
			perror(argv[i]);
			exit(1);
		}
	}

	exit(0);			/* Not reached */
}

/* EOF */
