#define NW802_MODEL
//#define NW801_MODEL

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <gtk/gtk.h>

static char *procpath;

static GtkWidget *LUTSliders[4][17];


#ifdef NW802_MODEL
#define LUT_R_FORALL_REG  0x1004
#define LUT_R_FORALL_MASK 0x10
static const int LUTRegBase[4] = { 0x1041, 0x1052, 0x1063, 0x1074 };

#define R_GAIN_REG 0x100B
#define G_GAIN_REG 0x100D
#define B_GAIN_REG 0x100C

#define Y_GAIN_REG 0x100E
#define U_GAIN_REG 0x100F
#define V_GAIN_REG 0x1010

#define SHUT1_REG 0x100C
#define SHUT2_REG 0x100D
#endif

#ifdef NW801_MODEL
#define LUT_R_FORALL_REG  0x1004
#define LUT_R_FORALL_MASK 0x10
static const int LUTRegBase[4] = { 0x1048, 0x1059, 0x106A, 0x107B };

#define R_GAIN_REG 0x100B
#define G_GAIN_REG 0x100D
#define B_GAIN_REG 0x100C

#define Y_GAIN_REG 0x100E
#define U_GAIN_REG 0x100F
#define V_GAIN_REG 0x1010

#define SHUT1_REG 0x100C
#define SHUT2_REG 0x100D
#endif


// -----------------------------------------------------------------------
// Registers read & Write
// -----------------------------------------------------------------------

unsigned char readReg( int addr ) {
	char buffer[20];
	int raddr, value;
	int procfd = -1;

	procfd=open(procpath, O_RDWR);	
	
	if ( procfd < 0 ) {
		perror("open");
		g_error("Can't open the driver proc interface\n");
		return 0;
	}
	
	snprintf(buffer, 19, "%04x", addr);
	write( procfd, buffer, 4 );
	read( procfd, buffer, 18 );
	buffer[20] = 0x00;
	sscanf(buffer,"Register %04x = %02x\n", &raddr, &value);
	if ( addr != raddr )
		g_warning("Address mismatch during read : %04X != %04X\n=> %s", addr, raddr,buffer);
	close(procfd);
	return value & 0xFF;
}

void writeReg( int addr, unsigned char val ) {
	char buffer[8];
	int procfd = -1;

	procfd=open(procpath, O_RDWR);	
	
	if ( procfd < 0 ) {
		perror("open");
		g_error("Can't open the driver proc interface\n");
		return;
	}
	snprintf(buffer, 8, "%04x=%02x", addr, val);
	write( procfd, buffer, 8 );

	close(procfd);
}

static void RLUTForAllToggled( GtkWidget *widget, gpointer data ) {
	unsigned char value;
	int addr;

	addr =  LUT_R_FORALL_REG ;
	value = readReg( LUT_R_FORALL_REG );

	if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) )
		value |= LUT_R_FORALL_MASK;
	else
		value &= ~LUT_R_FORALL_MASK;

	writeReg(addr, (unsigned char)(value));
}

static void SliderChanged( GtkWidget *widget, gpointer data ) {
	gdouble value;
	int addr;

	addr = ((int)data);
	value = gtk_range_get_value(GTK_RANGE(widget));

	writeReg(addr, (unsigned char)(value));
}

// -----------------------------------------------------------------------
// Main window callbacks
// -----------------------------------------------------------------------

static gboolean delete_event( GtkWidget *widget,
		GdkEvent  *event,
		gpointer   data )
{
	return FALSE;	// The window is to be destroyed
}

static void destroy( GtkWidget *widget,
		gpointer   data )
{
	// Just quit main gtk loop
	gtk_main_quit ();
}


// -----------------------------------------------------------------------
// Main
// -----------------------------------------------------------------------

void create_gui() {

	// Vars
	
		// Temps
	int i, j;
	GtkWidget *dummy;
	
		// Main layout
	GtkWidget *window;
	GtkWidget *vbox1, *vbox2;
	GtkWidget *hbox1, *hbox2;
	
	GtkWidget *RGBControls_frame;
	GtkWidget *YUVControls_frame;
	GtkWidget *ShutControls_frame;
	GtkWidget *MiscControls_frame;
	GtkWidget *LUTTables_frame;
	
		// LUT Frame
	GtkWidget *lutf_vbox, *lutf_nbook;
	
	
	
	// Create a window
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	g_signal_connect(G_OBJECT(window), "delete_event",
			G_CALLBACK (delete_event), NULL);
	g_signal_connect(G_OBJECT(window), "destroy",
			G_CALLBACK (destroy), NULL);

	//
	// Basic layout
	//

	// Create the first horizontal subdivision
	vbox1 = gtk_vbox_new(TRUE,1);
	gtk_widget_show(vbox1);
	gtk_container_add (GTK_CONTAINER (window), vbox1);


	// On the top, put 
	//  - RGB Gain/ofs
	//  - YUV Gain/ofs
	//  - Shutter control
	//  - Misc reg access
	hbox1 = gtk_hbox_new(TRUE,6);
	gtk_widget_show(hbox1);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox1, TRUE, TRUE, 0);

	RGBControls_frame = gtk_frame_new("RGB Gain/Ofs");
	gtk_widget_show(RGBControls_frame);
	gtk_box_pack_start(GTK_BOX(hbox1), RGBControls_frame, TRUE, TRUE, 0);
	
	YUVControls_frame = gtk_frame_new("YUV Gain/Ofs");
	gtk_widget_show(YUVControls_frame);
	gtk_box_pack_start(GTK_BOX(hbox1), YUVControls_frame, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new(TRUE,1);
	gtk_widget_show(vbox2);
	gtk_box_pack_start(GTK_BOX(hbox1), vbox2, TRUE, TRUE, 0);

	ShutControls_frame = gtk_frame_new("Shutter");
	gtk_widget_show(ShutControls_frame);
	gtk_box_pack_start(GTK_BOX(vbox2), ShutControls_frame, TRUE, TRUE, 0);

	MiscControls_frame = gtk_frame_new("Misc");
	gtk_widget_show(MiscControls_frame);
	gtk_box_pack_start(GTK_BOX(vbox2), MiscControls_frame, TRUE, TRUE, 0);

	// On the bottom, put LUT for R G B Y
	LUTTables_frame = gtk_frame_new("Look Up Tables");
	gtk_widget_show(LUTTables_frame);
	gtk_box_pack_start(GTK_BOX(vbox1), LUTTables_frame, TRUE, TRUE, 0);


	//
	// Frames filling
	//

#define createslider(reg,max,box) do { \
			dummy = gtk_vscale_new_with_range(0, max, 1); \
			gtk_scale_set_draw_value(GTK_SCALE(dummy), TRUE); \
			gtk_scale_set_digits(GTK_SCALE(dummy), 0); \
			gtk_range_set_inverted(GTK_RANGE(dummy), TRUE); \
			gtk_widget_show(dummy); \
			gtk_box_pack_start(GTK_BOX(box), dummy, TRUE, TRUE, 0); \
			gtk_range_set_value(GTK_RANGE(dummy), readReg(reg)); \
			g_signal_connect(G_OBJECT(dummy), "value_changed", \
				G_CALLBACK (SliderChanged), (void*)reg); \
} while(0)

		// RGB Offset & Gain
		// -----------------
		hbox2 = gtk_hbox_new(TRUE,0);
		gtk_widget_show(hbox2);
		gtk_container_add(GTK_CONTAINER(RGBControls_frame), hbox2);

		createslider(R_GAIN_REG,63,hbox2);	
		createslider(G_GAIN_REG,63,hbox2);	
		createslider(B_GAIN_REG,63,hbox2);	

		

		// YUV Offset & Gain
		// -----------------
		hbox2 = gtk_hbox_new(TRUE,0);
		gtk_widget_show(hbox2);
		gtk_container_add(GTK_CONTAINER(YUVControls_frame), hbox2);

		createslider(Y_GAIN_REG,63,hbox2);	
		createslider(U_GAIN_REG,63,hbox2);	
		createslider(V_GAIN_REG,63,hbox2);	
		

		// Shutter control
		// ---------------
		hbox2 = gtk_hbox_new(TRUE,0);
		gtk_widget_show(hbox2);
		gtk_container_add(GTK_CONTAINER(ShutControls_frame), hbox2);

		createslider(SHUT1_REG,255,hbox2);	
		createslider(SHUT2_REG,255,hbox2);	

		// Misc
		// ----

		// LUT Tables
		// ----------
	lutf_vbox = gtk_vbox_new(FALSE,1);
	gtk_widget_show(lutf_vbox);
	gtk_container_add(GTK_CONTAINER(LUTTables_frame), lutf_vbox);

	dummy = gtk_check_button_new_with_label("Use only R Table");
	gtk_widget_show(dummy);
	gtk_box_pack_start(GTK_BOX(lutf_vbox), dummy, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(dummy), "toggled",
		G_CALLBACK (RLUTForAllToggled), NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dummy), readReg(LUT_R_FORALL_REG) & LUT_R_FORALL_MASK);

	lutf_nbook = gtk_notebook_new();
	gtk_widget_show(lutf_nbook);
	gtk_box_pack_start(GTK_BOX(lutf_vbox), lutf_nbook, TRUE, TRUE, 0);

	for ( i=0 ; i<4 ; i++ ) {
		// Vars
		static const char *names[] = { "R", "G", "B", "Y" };
		GtkWidget *ihbox;

		// Create the label
		dummy = gtk_label_new(names[i]);
		gtk_widget_show(dummy);

		// Create the internal hbox
		ihbox = gtk_hbox_new(TRUE,0);
		gtk_widget_show(ihbox);

		// Insert the new page ( append )
		gtk_notebook_append_page(GTK_NOTEBOOK(lutf_nbook), ihbox, dummy);

		// Filling the ihbox
		for ( j=0 ; j<17 ; j++ ) {
			// Create the scale and configure it
			dummy = gtk_vscale_new_with_range(0, 255, 1);
			gtk_scale_set_draw_value(GTK_SCALE(dummy), TRUE);
			gtk_scale_set_digits(GTK_SCALE(dummy), 0);
			gtk_range_set_inverted(GTK_RANGE(dummy), TRUE);
			gtk_widget_show(dummy);
			gtk_box_pack_start(GTK_BOX(ihbox), dummy, TRUE, TRUE, 0);
			gtk_range_set_value(GTK_RANGE(dummy), readReg(LUTRegBase[i]+j));
			LUTSliders[i][j] = dummy;
		
			// Setup signals
			g_signal_connect(G_OBJECT(dummy), "value_changed",
				G_CALLBACK (SliderChanged), LUTRegBase[i]+j);
			
		}
	}

	// Show the window
	gtk_widget_show(window);

}

int main( int argc, char *argv[] ) {

	// Vars

	// Open the proc interface
	procpath = 
		( (argc > 1) && (argv[argc-1][0] != '-') ) ?
			argv[argc-1] : "/proc/video/nw802/video0";

	// Init GTK
	gtk_init(&argc, &argv);
	create_gui();

	// Main GTK processing loop
	gtk_main();

	// Return
	return 0;
}
