#!/usr/bin/perl
#
# $Id: RBPH.pm,v 1.3 2001/10/06 22:19:14 levine Exp $
#
# Copyright (C) 2001  James D. Levine (jdl@vinecorp.com)
#
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
#   02111-1307, USA.
#
####################################################################

use NWatch::PacketHandler;
use PortScan::ScannedHost;
use PortScan::ScanSet;

use strict;

package NWatch::RBPH;

@NWatch::RBPH::ISA = qw( NWatch::PacketHandler );

sub new
{
    my( $type, $template_scanset, $accept_any_host ) = @_;
    my $self = NWatch::PacketHandler::new( $type, $template_scanset, $accept_any_host );

#    $self->{template_scanset} = $template_scanset;

    bless $self, $type;

    $self;
}

sub handle_packet
{
    my( $self, $packet, $scanset ) = @_;

    # return if an uninteresting protocol
    # for now, assume all protocols are interesting

    # return if an uninteresting source/destination
    # for now, assume all source & destinations are interesting



    if( $packet->proto_isa( "ethernet:ipv4" ) )
	{
	    my $d = $packet->field_path( "ipv4:destination_address" );
	    my $dest = &NWatch::ipv4_packet::format_addr( $d );

	    my $s = $packet->field_path( "ipv4:source_address" );
	    my $source = &NWatch::ipv4_packet::format_addr( $s );

#	    print "->>> hpack dest $d formatted  $dest \n";
#	    print "hpack: dest length = " .length($d). "\n";

#	    print "->>> hpack source $s formatted  $source \n";

	    if( $packet->proto_isa( "ethernet:ipv4:tcp" ) )
	    {

		my $syn = $packet->field_path( "ipv4:tcp:syn" );
		my $ack = $packet->field_path( "ipv4:tcp:ack" );
		my $rst = $packet->field_path( "ipv4:tcp:rst" );

		my $port = $packet->field_path( "ipv4:tcp:source_port" );

#		print "tcp: syn $syn ack $ack rst $rst \n";

		# any syn-ack -> open
		# any SND from "server" is open

		if(
		   ( $syn && $ack )
		   )	# we assume connection is open on this port
		{
#		    print "**** OPEN TCP PORT: $source:" . $packet->get( "ethernet:ipv4:tcp:source_port" ) . "\n";

		    my $host = $self->get_or_create_host( $scanset, $source, $self->accept_any_host );

		    if( defined $host )
		    {
			my $pspec = new PortScan::PortSpec( $port, "open", "tcp", "", "", "", "" );
			$host->add_port( $pspec );

			# ensure scanset has the port
		    }
		}

		# any RST when not (syn-ack sent previously) -> CLOSED
		
		elsif( $rst )
		{
		    my $host = $self->get_or_create_host( $scanset, $source, $self->accept_any_host );

		    if( defined $host )
		    {
			my $pspec = new PortScan::PortSpec( $port, "closed", "tcp", "", "", "", "" );
			$host->add_port( $pspec );

#			print "**** CLOSED TCP PORT: $source:". $packet->get( "ethernet:ipv4:tcp:source_port" ) . "\n";
		    }
		}
		# filtered not detected

	    }
	    elsif( $packet->proto_isa( "ethernet:ipv4:udp" ) )
	    {

	    }

	}

}





sub get_or_create_host
{
    my( $self, $scanset, $address, $accept_any_host ) = @_;

    my $host =  $scanset->get_host( $address );

#    print "goch: template " . $self->template_scanset() . "\n";
#    print "goch: host " . $host . "\n";


    if( ! defined( $host ) )
    {
	my $template_host =  $self->template_scanset()->get_host( $address );
	
	if( $accept_any_host || (defined $template_host) ) 
	{
	    my $new_host = new PortScan::ScannedHost( $address );
	    $new_host->addr( $address );
	    $new_host->default_state( "unknown" );

	    print "adding new host $address.\n";
	    $scanset->add_host( $new_host );

	    return $new_host;
	}
	else
	{
#	    print "goch: skipping host $address \n";
	    return undef;
	}
    }


#    print "goch: $address - $host \n";

    $host;
}

1;










