<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/user.php");
include_once("./functions/widgets.php");
include_once("./functions/datetime.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item.php");
include_once("./functions/http.php");
include_once("./functions/review.php");
include_once("./functions/email.php");
include_once("./functions/item_input.php");

/**
	Will return javascript validation.  This a hack and a half, but it does the job...
	There is multiple if($op==) checks because I want the validations to fire in order of the input fields.
*/
function check_user_type_change_js($uid, $admin_uid)
{
	// So we can access the language messages.
	global $LANG_VARS;

	$javascript .= "
		<script language=\"JavaScript\">
		<!-- // hide from stupid browsers
		
		//
		// Check User Type Change, when it reduces status of user.
		//
		function checkUserTypeChange(radioGroup)
		{
			var defaultIndex=-1;
			var checkedIndex=-1;
			
			// Get the defaultChecked information.
			for (var i=0; i<radioGroup.length; i++ )
			{
				if (radioGroup[i].defaultChecked)
				{
					// No change, so we can exit immediately.
					if(radioGroup[i].checked)
						return true;
					else
						defaultIndex=i;
				}
				else if(radioGroup[i].checked)
					checkedIndex=i;
			}
			
			// At this stage, both defaultIndex and checkedIndex should be defined.
			if(defaultIndex!==-1 && checkedIndex!==-1)
			{
				if(radioGroup[defaultIndex].value == 'A' && (radioGroup[checkedIndex].value == 'N' || radioGroup[checkedIndex].value == 'B' || radioGroup[checkedIndex].value == 'G'))
				{";

	//this php if
	if($uid===$admin_uid)//is own record.
		$javascript .= "msg = '".replace_lang_var("usertype", $LANG_VARS['administrator'], $LANG_VARS['confirm_your_type_change'])."';";
	else
		$javascript .= "msg = '".replace_lang_vars(array('user_id'=>$uid,'usertype'=>$LANG_VARS['administrator']), $LANG_VARS['confirm_user_type_change'])."';";
	
	$javascript .= 
				"}
				else if(radioGroup[defaultIndex].value == 'N' && (radioGroup[checkedIndex].value == 'G' || radioGroup[checkedIndex].value == 'B'))
				{";

	//this php if
	if($uid===$admin_uid)//is own record.
		$javascript .= "msg = '".replace_lang_var("usertype", $LANG_VARS['normal'], $LANG_VARS['confirm_your_type_change'])."';";
	else
		$javascript .= "msg = '".replace_lang_vars(array('user_id'=>$uid,'usertype'=>$LANG_VARS['normal']), $LANG_VARS['confirm_user_type_change'])."';";

	$javascript .= 
				"}
				else if(radioGroup[defaultIndex].value == 'B' && radioGroup[checkedIndex].value == 'G')
				{";
		
	//this php if
	if($uid===$admin_uid)//is own record.
		$javascript .= "msg = '".replace_lang_var("usertype", $LANG_VARS['borrower'], $LANG_VARS['confirm_your_type_change'])."';";
	else
		$javascript .= "msg = '".replace_lang_vars(array('user_id'=>$uid,'usertype'=>$LANG_VARS['borrower']), $LANG_VARS['confirm_user_type_change'])."';";
		
	$javascript .= 
				"}
				else // No reduction in user level.
					msg = null;
						
				if(msg!=null)
				{
					if(!confirm(msg)){
						radioGroup[defaultIndex].checked = true;
					}
				}
			}
		}
		// -->
		</script>";
			
	return $javascript;			
}

/**
	If $uid defined, then we assume that we are in edit mode
	and modify the logic appropriately!
*/
function get_usertype_field($user_id=NULL,$user_type=NULL)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	// We have to cater for a $USER_TYPE field only, which will match the radio value only.
	if(strlen($user_id)>0 && strlen($user_type)>0)
	{
		if(is_user_admin($user_id,$user_type))
			$user_type_val = 'A';
		else if(is_user_normal($user_id,$user_type))
			$user_type_val = 'N';
		else if(is_user_borrower($user_id,$user_type))
			$user_type_val = 'B';
		else if(is_user_guest($user_id,$user_type))
			$user_type_val = 'G';
	}
	else if(strlen($user_type)>0 && ($user_type == 'A' || $user_type == 'N' || $user_type == 'B' || $user_type == 'G'))
		$user_type_val = $user_type;
	else
		$user_type_val = 'N';
		
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
		$onclick = "onclick=\"checkUserTypeChange(this.form.usertype)\"";
	
	// This is a custom field, that would not be used anywhere else, so
	// do not bother using formatfield.php get_input_field function.
	$field = "\n<table><tr>".
			format_data(NULL, "\n<input type=\"radio\" name=\"usertype\" value=\"A\" ".(strlen($user_id)>0?$onclick:"").($user_type_val=='A'?" CHECKED":"").">".$LANG_VARS['administrator']).
			format_data(NULL, "\n<input type=\"radio\" name=\"usertype\" value=\"N\" ".(strlen($user_id)>0?$onclick:"").($user_type_val=='N'?" CHECKED":"").">".$LANG_VARS['normal']).
			"\n</tr>".
			"\n<tr>".
			format_data(NULL, "\n<input type=\"radio\" name=\"usertype\" value=\"B\" ".(strlen($user_id)>0?$onclick:"").($user_type_val=='B'?" CHECKED":"").">".$LANG_VARS['borrower']).
			format_data(NULL, "\n<input type=\"radio\" name=\"usertype\" value=\"G\" ".(strlen($user_id)>0?$onclick:"").($user_type_val=='G'?" CHECKED":"").">".$LANG_VARS['guest']).
			"\n</tr>".
			"\n</table>";
	
	return format_field($LANG_VARS['user_type'], NULL, $field);
}

/**
	This form is a bit of a kludge, especially the javascript validation.
*/ 
function get_user_input_form($user_r, $HTTP_VARS)
{
	global $CONFIG_VARS;
	global $_OPENDB_THEME;
	global $LANG_VARS;
	global $PHP_SELF;
	global $HTTP_SESSION_VARS;
	
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
	{
		// Include validation javascript, which will validate data input.
		$buffer = get_validation_javascript();
	
		// If user defined, then include User Type Change validation, otherwise do not.
		if(is_not_empty_array($user_r))
		{
			$buffer .= check_user_type_change_js($user_r['user_id'], $HTTP_SESSION_VARS['user_id']);
		}		
	}
	
	$buffer .= 
		"<table border=0 frameborder=0 cellspacing=1 cellpadding=1>".
		"<form action=\"$PHP_SELF\" method=\"post\">";

	if(is_not_empty_array($user_r))
	{
		$buffer .= get_input_field("uid",
				NULL, // s_attribute_type
				$LANG_VARS['userid'], 
				"readonly", //input type.
				"", //compulsory!
				$user_r['user_id'],
				TRUE);
	}
	else
	{
		$buffer .= get_input_field("uid",
				NULL, // s_attribute_type
				$LANG_VARS['userid'], 
				"filtered(20,20,a-zA-Z0-9_.)", //input type.
				"Y", //compulsory!
				$HTTP_VARS['uid'],
				TRUE);
	}			
	
	$buffer .= get_input_field("fullname",
				NULL, // s_attribute_type
				$LANG_VARS['fullname'], 
                "text(30,100)", //input type.
   	            "Y", //compulsory!
       	        ifempty($HTTP_VARS['fullname'],$user_r['fullname']),
				TRUE);
	
	$buffer .= get_input_field("location",
				NULL, // s_attribute_type
				$LANG_VARS['location'], 
           	    "text(30,50)", //input type.
               	"Y", //compulsory!
				ifempty($HTTP_VARS['location'],$user_r['location']),
				TRUE);

	$buffer .= get_input_field("email",
				NULL, // s_attribute_type
				$LANG_VARS['email'], 
                "email(30,50)", //input type.
   	            "Y", //compulsory!
       	        ifempty($HTTP_VARS['email'],$user_r['email']),
				TRUE);
			
	if($CONFIG_VARS['user_admin.user_themes_support']!==FALSE)
	{	
		$uid_theme = ifempty($HTTP_VARS['uid_theme'],$user_r['theme']);
		$buffer .= format_field($LANG_VARS['user_theme'], 
						NULL, 
						custom_select("uid_theme", get_user_theme_r(), "%value%", 1, is_legal_user_theme($uid_theme)?$uid_theme:$CONFIG_VARS['site.theme']));// If theme no longer exists, then set to default!
	}
	
	if($CONFIG_VARS['user_admin.user_language_support']!==FALSE)
	{	
		$language_r = get_language_r();
		
		// Do not bother with language input field if only one language pack available.
		if(count($language_r)>1)
		{
			$uid_language = ifempty($HTTP_VARS['uid_language'],$user_r['language']);
			$buffer .= format_field($LANG_VARS['user_language'], 
							NULL, 
							custom_select("uid_language", $language_r, "%value%", 1, is_legal_language($uid_language)?$uid_language:$CONFIG_VARS['site.language']));// If language no longer exists, then set to default!
		}				
	}
	
	// Only have change password for 'update' mode where allowed to change passwords.
	if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if(is_not_empty_array($user_r))
			$buffer .= get_usertype_field($user_r['user_id'], $user_r['type']);
		else
			$buffer .= get_usertype_field(NULL, $HTTP_VARS['usertype']);
	}
	
	// Either new-user (is_array($user_r)) OR 
	if(!is_array($user_r) || $CONFIG_VARS['user_admin.user_passwd_change_allowed']!==FALSE || is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
	{
		$buffer .= "\n<tr><td colspan=2>&nbsp;</td></tr>";
		
		$buffer .= get_input_field("pwd",
				NULL, // s_attribute_type
				$LANG_VARS['new_passwd'], 
                "password(30,40)", //input type.
				"N", //compulsory!
				"",
				TRUE);
				
		$buffer .= get_input_field("confirmpwd",
				NULL, // s_attribute_type
				$LANG_VARS['confirm_passwd'], 
				"password(30,40)", //input type.
				"N", //compulsory!
				"",
				TRUE,
				NULL,
				$CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE?"if( (this.form.pwd.value.length!=0 || this.form.confirmpwd.value.length!=0) && this.form.pwd.value!=this.form.confirmpwd.value){alert('".$LANG_VARS['passwds_do_not_match']."'); this.focus(); return false;}":"");
	}
	
	$buffer .= "\n<tr>";
	
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
		$onclick_event = "if(!checkForm(this.form)){return false;}else{this.form.submit();}";
	else
		$onclick_event = "this.form.submit();";
						
	// If user_id defined, we are in update mode.			
	if(is_not_empty_array($user_r))
	{		
		$buffer .= "\n<input type=\"hidden\" name=\"op\" value=\"update\">";
			
		if($HTTP_VARS['uid'] != $HTTP_SESSION_VARS['user_id'])
		{
			$buffer .= "\n<td><input type=\"button\" onclick=\"this.form.op.value='update'; $onclick_event\" value=\"".$LANG_VARS['update_user']."\">";
			
			if(is_user_active($HTTP_VARS['uid']) && $CONFIG_VARS['user_admin.user_delete_support'] !== FALSE)
			{
				if($CONFIG_VARS['user_admin.user_delete_support'] === TRUE)
					$buffer .= "\n<td><input type=\"button\" onclick=\"this.form.op.value='delete'; this.form.submit();\" value=\"".$LANG_VARS['delete_user']."\"></td>";
				else if($CONFIG_VARS['user_admin.user_delete_support'] === 'deactivate')
					$buffer .= "\n<td><input type=\"button\" onclick=\"this.form.op.value='deactivate'; this.form.submit();\" value=\"".$LANG_VARS['deactivate_user']."\"></td>";
			}
			else
				$buffer .= "\n<td>&nbsp;</td>";
		}
		else
		{
			$buffer .= "\n<td colspan=2 align=left>".
					"\n<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['update_details']."\">";
		}
	}
	else //insert mode
	{
		$buffer .= "\n<td colspan=2>".
					"\n<input type=\"hidden\" name=\"op\" value=\"insert\">".
				"\n<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['add_user']."\">";
				
		if($CONFIG_VARS['email.use_php_mail']!==FALSE)
		{
			// If we are actually showing the form, because an insert has failed,
			// we should set the email_user indicator according to what the user
			// has chosen.
			if($HTTP_VARS['op'] == "insert")
			{
				if($HTTP_VARS['email_user']=='Y')
					$checked = "CHECKED";
				else
					$checked = "";
			}						
			else
				$checked = "CHECKED";
			
			$buffer .= "<input type=\"checkbox\" name=\"email_user\" value=\"Y\" $checked>".
						$LANG_VARS['send_welcome_email'];
		}
		//else
		$buffer .= "</td>";
	}		

	$buffer .= "\n</tr>".
				"\n</form>".
			"</table>";

	// insert user
	if(!is_array($user_r))
		$buffer .= format_help_block($LANG_VARS['user_add_help']);
	
	return $buffer;		
}

/*
*/
function handle_user_insert(&$HTTP_VARS, &$errors)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;

	// We need to check if user already exists, so we can return a nice error.
	// A userid cannot differ in case alone!
	if(!is_user_valid($HTTP_VARS['uid'], TRUE))
	{
		// Remove all invalid characters and set to lower case.	
		$HTTP_VARS['uid'] = strtolower(preg_replace("/[\s|'|\\\\|\"]+/", "", trim(strip_tags($HTTP_VARS['uid']))));
		// Ensure users do not cause trouble by inserting html code.
		$HTTP_VARS['fullname'] = trim(strip_tags($HTTP_VARS['fullname']));
		$HTTP_VARS['location'] = trim(strip_tags($HTTP_VARS['location']));
		$HTTP_VARS['email']= trim(str_replace('>',' ', strip_tags($HTTP_VARS['email'])));

		if(validate_input_field(NULL, $LANG_VARS['userid'], "filtered(20,20,a-zA-Z0-9_.)", "Y", $HTTP_VARS['uid'], $errors) &&
					validate_input_field(NULL, $LANG_VARS['fullname'], "text(30,100)", "Y", $HTTP_VARS['fullname'], $errors) &&
					validate_input_field(NULL, $LANG_VARS['location'], "text(30,50)", "Y", $HTTP_VARS['location'], $errors) && 
					validate_input_field(NULL, $LANG_VARS['email'], "email(30,50)", "Y", $HTTP_VARS['email'], $errors))
		{
			// If no password specified, generate one
			if(strlen($HTTP_VARS['pwd'])==0)
			{
				$HTTP_VARS['pwd'] = generate_password(8);
			}
			else if($HTTP_VARS['pwd'] != $HTTP_VARS['confirmpwd'])
			{
				$errors[] = array('error'=>$LANG_VARS['passwds_do_not_match']);
				return FALSE;
			}
			
			// Do not allow update with illegal theme!
			if($CONFIG_VARS['user_admin.user_themes_support']===FALSE || !is_legal_user_theme($HTTP_VARS['uid_theme']))
				$HTTP_VARS['uid_theme'] = NULL;

			// Do not allow update with illegal language.			
			if($CONFIG_VARS['user_admin.user_language_support']===FALSE || !is_legal_language($HTTP_VARS['uid_language']))
				$HTTP_VARS['uid_language'] = NULL;

			if(insert_user($HTTP_VARS['uid'], $HTTP_VARS['fullname'], $HTTP_VARS['pwd'], $HTTP_VARS['usertype'], $HTTP_VARS['location'], $HTTP_VARS['email'], $HTTP_VARS['uid_language'], $HTTP_VARS['uid_theme']))
			{
				return TRUE;
			}
			else
			{
				$errors[] = array('error'=>replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_not_added']),'detail'=>mysql_error());
				return FALSE;
			}
		}
		else // not all required information specified
		{
			return FALSE;				
		}
	}			
	else
	{
		$errors[] = array('error'=>replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_exists']),'detail'=>'');
		return FALSE;
	}
}

/*
*/
function handle_user_update(&$HTTP_VARS, &$errors)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	if(is_user_valid($HTTP_VARS['uid']))
	{
		// Ensure users do not cause trouble by inserting html code.
		$HTTP_VARS['fullname'] = trim(strip_tags($HTTP_VARS['fullname']));
		$HTTP_VARS['location'] = trim(strip_tags($HTTP_VARS['location']));
		$HTTP_VARS['email']= trim(str_replace('>',' ', strip_tags($HTTP_VARS['email'])));

		if(validate_input_field(NULL, $LANG_VARS['fullname'], "text(30,100)", "Y", $HTTP_VARS['fullname'], $errors) &&
				validate_input_field(NULL, $LANG_VARS['location'], "text(30,50)", "Y", $HTTP_VARS['location'], $errors) &&
				validate_input_field(NULL, $LANG_VARS['email'], "email(30,50)", "Y", $HTTP_VARS['email'], $errors))
		{
			// Do not allow update with illegal theme!
			if($CONFIG_VARS['user_admin.user_themes_support']===FALSE || !is_legal_user_theme($HTTP_VARS['uid_theme']))
				$HTTP_VARS['uid_theme'] = FALSE; // Do not update theme!
				
			// Do not allow update with illegal language.			
			if($CONFIG_VARS['user_admin.user_language_support']===FALSE || !is_legal_language($HTTP_VARS['uid_language']))
				$HTTP_VARS['uid_language'] = NULL;
			
			if(update_user($HTTP_VARS['uid'], $HTTP_VARS['fullname'], $HTTP_VARS['location'], $HTTP_VARS['email'], $HTTP_VARS['uid_language'], $HTTP_VARS['uid_theme'], FALSE))
			{
				// No errors recorded at this stage.
				$errors = NULL;
				
				// Now update user_type if current user is administrator.
				if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
				{
					if(fetch_user_type($HTTP_VARS['uid']) !== $HTTP_VARS['usertype'])
					{
						// First of all validate that type can be changed.
						if(($HTTP_VARS['usertype'] == 'B' || $HTTP_VARS['usertype'] == 'G') && is_exists_item_instance_with_owner($HTTP_VARS['uid']))
						{
							$errors[] = array('error'=>$LANG_VARS['usertype_not_updated'],'detail'=>$LANG_VARS['usertype_not_updated_for_user_with_items']);
						}
						else if($HTTP_VARS['usertype'] == 'G' && (fetch_owner_reserved_item_cnt($HTTP_VARS['uid'])>0 || fetch_owner_borrowed_item_cnt($HTTP_VARS['uid'])>0))
						{
							$errors[] = array('error'=>$LANG_VARS['usertype_not_updated'],'detail'=>$LANG_VARS['usertype_not_updated_for_user_with_borrow_or_reserve_items']);
						}
						else if(!update_user_type($HTTP_VARS['uid'], $HTTP_VARS['usertype']))
						{
							$errors[] = array('error'=>$LANG_VARS['usertype_not_updated'],'detail'=>mysql_error());
						}
					}
				}
				
				// If at least one password specified, we will try to perform update.
				if(strlen($HTTP_VARS['pwd'])>0 || strlen($HTTP_VARS['confirmpwd'])>0)
				{
					if($CONFIG_VARS['user_admin.user_passwd_change_allowed']!==FALSE || is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
					{
						if ($HTTP_VARS['pwd'] != $HTTP_VARS['confirmpwd'])
						{
							$errors[] = array('error'=>$LANG_VARS['passwd_not_changed'],'detail'=>$LANG_VARS['passwds_do_not_match']);
						}
						else if(strlen($HTTP_VARS['pwd'])==0)
						{
							$errors[] = array('error'=>$LANG_VARS['passwd_not_changed'],'detail'=>$LANG_VARS['passwd_not_specified']);
						}
						else
						{
							if(!update_user_passwd($HTTP_VARS['uid'], $HTTP_VARS['pwd']))
							{
								$errors[] = array('error'=>$LANG_VARS['passwd_not_changed'],'detail'=>mysql_error());
							}
						}
					}
					else
					{
						$errors[] = array('error'=>$LANG_VARS['passwd_not_changed']);
					}
				}
				
				// At this point the $errors are warnings only!
				return TRUE;						
			}    
			else
			{
				$errors[] = array('error'=>replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_not_updated']),'detail'=>mysql_error());
				return FALSE;
			}
		}
		else // not all required information specified
		{
			return FALSE;
		}
	}
	else
	{
		$errors[] = array('error'=>replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_not_found']));
		return FALSE;
	}		
}

/*
* The Deactivate process will not delete any records.  All pending reservations
* for the users items, and made by the user will be cancelled, but thats it.
*/
function handle_user_deactivate($uid, $HTTP_VARS, &$errors)
{
	global $HTTP_SESSION_VARS;
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	if($CONFIG_VARS['user_admin.user_delete_support'] === 'deactivate')
	{
		if($uid == $HTTP_SESSION_VARS['user_id'])
		{
			$errors[] = array('error'=>$LANG_VARS['cannot_deactivate_yourself'],'detail'=>'');
			return FALSE;
		}
		else if(fetch_my_borrowed_item_cnt($uid)>0)
		{
			$errors[] = array('error'=>$LANG_VARS['user_with_borrows_not_deactivated'],'detail'=>'');
			return FALSE;
		}
		else if(fetch_owner_borrowed_item_cnt($uid)>0)
		{
			$errors[] = array('error'=>$LANG_VARS['user_with_owner_borrows_not_deactivated'],'detail'=>'');
			return FALSE;
		}
		else if($HTTP_VARS['confirmed'] == 'true')
		{
			// Cancel all reservations.
			$results = fetch_owner_reserved_item_rs($uid);
			if($results)
			{
				while($borrowed_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					cancel_reserve_item($borrowed_item_r['sequence_number']);
				}
				mysql_free_result($results);
			}
	
			$results = fetch_my_reserved_item_rs($uid);
			if($results)
			{
				while($borrowed_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					cancel_reserve_item($borrowed_item_r['sequence_number']);
				}
				mysql_free_result($results);
			}

			// deactivate user.
			if(deactivate_user($uid))
				return TRUE;
			else
				return FALSE;
		}
		else if($HTTP_VARS['confirmed'] != 'false')// confirmation required.
		{
			return "__CONFIRM__";
		}
		else 
		{
			return "__ABORTED__";				
		}
	}
	else // if($CONFIG_VARS['user_admin.user_delete_support'] === 'deactivate')
	{
		$errors[] = array('error'=>$LANG_VARS['user_deactivate_not_supported'],'detail'=>'');
		return FALSE;
	}
}

/*
* The validation for deleting a user, is exactly the same as for 
* deactivating one, except where this function actually returns
* __DEACTIVATE__, which indicates that the user is available for
* deactivation.
* 
* @param $op - 'delete' or 'deactivate' if delete is not possible because of
* borrowed items and/or item_instance records.
* 
*/
function handle_user_delete($uid, $HTTP_VARS, &$errors)
{
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	global $CONFIG_VARS;
	
	if($CONFIG_VARS['user_admin.user_delete_support'] === TRUE)
	{
		// We need to ensure that the user does not have any titles or borrowed/reserved items.
		if($uid == $HTTP_SESSION_VARS['user_id'])
		{
			$errors[] = array('error'=>$LANG_VARS['cannot_delete_yourself'],'detail'=>'');
			return FALSE;
		}
		else if(fetch_my_borrowed_item_cnt($uid)>0)
		{
			$errors[] = array('error'=>$LANG_VARS['user_with_borrows_not_deleted'],'detail'=>'');
			return FALSE;
		}
		else if(fetch_owner_borrowed_item_cnt($uid)>0)
		{
			$errors[] = array('error'=>$LANG_VARS['user_with_owner_borrows_not_deleted'],'detail'=>'');
			return FALSE;
		}
		
		// Now that we can proceed, we need to know whether we are performing a Delete or Deactivate
		// operation.
		if($CONFIG_VARS['user_admin.user_delete_with_reviews']!==TRUE && is_user_author($uid, TRUE)>0)
		{
			$errors = array('error'=>$LANG_VARS['user_with_reviews_not_deleted'],'detail'=>'');
			$confirm_operation = "__CONFIRM_DEACTIVATE__";
		}
		else if($CONFIG_VARS['user_admin.user_delete_with_borrower_inactive_borrowed_items']!==TRUE && (fetch_my_reserved_item_cnt($uid)>0 || fetch_my_history_item_cnt($uid)>0))
		{
			$errors = array('error'=>$LANG_VARS['user_with_inactive_borrowed_items_not_deleted'],'detail'=>'');
			$confirm_operation = "__CONFIRM_DEACTIVATE__";
		}
		else if($CONFIG_VARS['user_admin.user_delete_with_owner_inactive_borrowed_items']!==TRUE && (fetch_owner_reserved_item_cnt($uid)>0 || fetch_owner_history_item_cnt($uid)>0))
		{
			$errors = array('error'=>$LANG_VARS['user_with_owner_inactive_borrowed_items_not_deleted'],'detail'=>'');
			$confirm_operation = "__CONFIRM_DEACTIVATE__";
		}
		else // User can be completely deleted
		{
			$confirm_operation = "__CONFIRM__";
		}
				
		// If already confirmed operation.
		if($HTTP_VARS['confirmed'] == 'true')
		{
			// We are proceeding with the delete operation here.
			if($confirm_operation == "__CONFIRM__")
			{
				// Delete all user reviews.
				if(is_user_author($uid))
					delete_author_reviews($uid);
				
				// Delete all inactive borrowed items
				delete_my_inactive_borrowed_items($uid);
				
				// If no items, we can proceed to delete user.
				$results = fetch_owner_item_id_and_title_rs($uid);
				if($results)
				{
					// For each item, check if there are any dependencies.  If not, delete the
					// item_instance, and the item itself if no other instances.  Delete all
					// reviews, if this is the only dependency.
					while($item_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						delete_item_instance_inactive_borrowed_items($item_r['item_id'], $item_r['instance_no']);
						
						// The handle_item_delete does all the required checking before proceeding to
						// delete the item, so call it straight away.
						if(!handle_item_delete(NULL, $item_r, fetch_status_type_r($item_r['s_status_type']), array('confirmed'=>'true'), $error))
						{
							// Do nothing, as handle_item_delete will log failed deletions.
						}
					}
					mysql_free_result($results);
				}
			}
			else//if($confirm_operation == "__CONFIRM__")
			{
				// Cancel all reservations.
				$results = fetch_owner_reserved_item_rs($uid);
				if($results)
				{
					while($borrowed_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						cancel_reserve_item($borrowed_item_r['sequence_number']);
					}
					mysql_free_result($results);
				}
	
				$results = fetch_my_reserved_item_rs($uid);
				if($results)
				{
					while($borrowed_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						cancel_reserve_item($borrowed_item_r['sequence_number']);
					}
					mysql_free_result($results);
				}
			}
				
			if($confirm_operation == "__CONFIRM_DEACTIVATE__" || 
						is_user_author($uid, TRUE)>0 || // If user has any dependent records left we cannot continue.
						is_exists_borrower_borrowed_item($uid) || 
						is_exists_item_instance_with_owner($uid))
			{
				if(deactivate_user($uid))
					return "__DEACTIVATED__";
				else
					return FALSE;
			}
			else // user can be completely deleted.
			{
				if(delete_user($uid))
					return TRUE;
				else
				{
					$errors = array('error'=>$LANG_VARS['user_not_deleted'],'detail'=>mysql_error());
					return FALSE;
				}
			}
		}
		else if($HTTP_VARS['confirmed'] != 'false')// confirmation required.
		{
			return $confirm_operation;
		} 
		else 
		{
			return "__ABORTED__";				
		}
	}
	else // if($CONFIG_VARS['user_admin.user_delete_support'] === TRUE)
	{
		$errors = array('error'=>$LANG_VARS['user_delete_not_supported'],'detail'=>'');
		return FALSE;
	}
}

session_start();
if (is_opendb_valid_session())
{ 
	if ( ($HTTP_VARS['uid'] === $HTTP_SESSION_VARS['user_id'] && $HTTP_VARS['op'] != "insert" && $HTTP_VARS['op'] != "new_user" && $HTTP_VARS['op'] != "deactivate" && !is_user_guest($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']) ) || 
		is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']) ) // Can only access if admin or own user (not guest) record.
	{
		if($HTTP_VARS['op'] == "insert") //inserting a new record.
		{
			echo _theme_header($LANG_VARS['create_new_user']);
			echo("<h2>".$LANG_VARS['create_new_user']."</h2>");
			
			if(handle_user_insert($HTTP_VARS, $errors))
			{
				echo("\n<div class=\"success\">".replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_added'])."</div>");

				if($HTTP_VARS['email_user'] == "Y")
				{
					$from       = fetch_user_email($HTTP_SESSION_VARS['user_id']);
					$from_name  = fetch_user_name($HTTP_SESSION_VARS['user_id']);
					$subject    = replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['welcome_to_site']);
					$message    = replace_lang_var("fullname", fetch_user_name($HTTP_VARS['uid']), expand_langvar_newlines($LANG_VARS['to_user_email_intro'])).
								"\n\n".
									expand_langvar_newlines(replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['welcome_email'])).
								 "\n\n".
			    	    	     $LANG_VARS['userid'].": ".$HTTP_VARS['uid']."\n".
			        	    	 $LANG_VARS['new_passwd'].": ".$HTTP_VARS['pwd'];
							
					// Provide a link to open User Info form in edit mode.
					$message .= "\n\n".
							$LANG_VARS['edit_my_info'].":\n".
								"    ".get_site_url()."user_admin.php?op=edit&uid=".urlencode($HTTP_VARS['uid']);
				 
					// In this case ask the email function not to append [OpenDb] to subject line, as we will already
					// be including it!
					$results = opendb_email($HTTP_VARS['email'], $HTTP_VARS['fullname'], $from, $from_name, $subject, $message, FALSE);
					if($results!==TRUE)
					{
						echo format_error_block(
							array('error'=>replace_lang_vars(array("fullname"=>$HTTP_VARS['fullname'],"user_id"=>$HTTP_VARS['uid']), $LANG_VARS['welcome_email_error']),'detail'=>$results));
					}
					else
					{
						echo("\n<br><div class=\"smsuccess\">".replace_lang_vars(array("fullname"=>$HTTP_VARS['fullname'],"user_id"=>$HTTP_VARS['uid']), $LANG_VARS['welcome_email_sent'])."</div>");
					}
				}
				
				$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&uid=".$HTTP_VARS['uid'],text=>($HTTP_VARS['uid'] == $HTTP_SESSION_VARS['user_id']?$LANG_VARS['edit_my_info']:$LANG_VARS['edit_user_info']));
			}
			else
			{
				echo format_error_block($errors);
				echo get_user_input_form(NULL,$HTTP_VARS);
			}
		}
		else if($HTTP_VARS['op'] == "update")
		{
			if($HTTP_VARS['uid'] == $HTTP_SESSION_VARS['user_id'])
				$page_title = $LANG_VARS['my_info'];
			else
				$page_title = $LANG_VARS['user_info'];
			
			echo _theme_header($page_title);
			echo("<h2>".$page_title."</h2>");
			
			if(handle_user_update($HTTP_VARS, $errors))
			{
				echo("<div class=\"success\">".$LANG_VARS['user_updated']."</div>");
				
				// Any warnings that should be displayed.
				if($errors!==NULL)
					echo format_error_block($errors);
					
				// If updating current user, then update theme!!!
				if($HTTP_VARS['uid'] === $HTTP_SESSION_VARS['user_id']) 
				{
					if(strlen($HTTP_VARS['uid_theme'])>0)
					{
						$HTTP_SESSION_VARS['user_theme'] = $HTTP_VARS['uid_theme'];
						if(is_register_globals_enabled())
						{
							session_register("user_theme");
							$user_theme = $HTTP_SESSION_VARS['user_theme'];
						}
					}
					
					if(strlen($HTTP_VARS['uid_language'])>0)
					{
						$HTTP_SESSION_VARS['user_language'] = $HTTP_VARS['uid_language'];
						if(is_register_globals_enabled())
						{
							session_register("user_language");
							$user_language = $HTTP_SESSION_VARS['user_language'];
						}
					}
				}
				
				$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&uid=".$HTTP_VARS['uid'],text=>($HTTP_VARS['uid'] == $HTTP_SESSION_VARS['user_id']?$LANG_VARS['edit_my_info']:$LANG_VARS['edit_user_info']));
			}
			else
			{
				echo format_error_block($errors);
				
				$user_r = fetch_user_r($HTTP_VARS['uid']);
				if(is_not_empty_array($user_r))
				{
					echo get_user_input_form($user_r,$HTTP_VARS);
				}
				else //user not found.
				{
					echo _theme_error(
							replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_not_found']));
				}
			}
		}
		else if($HTTP_VARS['op'] == "delete")
		{
			echo _theme_header($LANG_VARS['user_delete']);
			echo("<h2>".$LANG_VARS['user_delete']."</h2>");

			if(is_user_valid($HTTP_VARS['uid']))
			{
				$return_val = handle_user_delete($HTTP_VARS['uid'], $HTTP_VARS, $errors);
				if($return_val === "__CONFIRM__")
				{
					echo get_op_confirm_form(
							$PHP_SELF,
							replace_lang_vars(array("fullname"=>fetch_user_name($HTTP_VARS['uid']),"user_id"=>$HTTP_VARS['uid']), $LANG_VARS['confirm_user_delete']), 
							$HTTP_VARS);
				}
				else if($return_val === "__CONFIRM_DEACTIVATE__")
				{
					echo format_error_block($errors);
					echo get_op_confirm_form(
									$PHP_SELF, 
									replace_lang_vars(array("fullname"=>fetch_user_name($HTTP_VARS['uid']),"user_id"=>$HTTP_VARS['uid']), $LANG_VARS['confirm_user_delete_deactivate']),
									$HTTP_VARS);
				}
				else if($return_val === "__ABORTED__")
				{
					echo("<div class=\"success\">".$LANG_VARS['user_not_deleted']."</div>");
					$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&uid=".$HTTP_VARS['uid'],text=>($HTTP_VARS['uid'] == $HTTP_SESSION_VARS['user_id']?$LANG_VARS['edit_my_info']:$LANG_VARS['edit_user_info']));
				}
				else if($return_val === "__DEACTIVATED__")
				{
					echo("<div class=\"success\">".$LANG_VARS['user_deactivated']."</div>");
				}
				else if($return_val === TRUE)
				{
					echo("<div class=\"success\">".$LANG_VARS['user_deleted']."</div>");
				}
				else //if($return_val === FALSE)
				{
					echo format_error_block($errors);
				}
			}
			else
			{
				echo _theme_error(
						replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_not_found']));
			}				
		}
		else if($HTTP_VARS['op'] == "deactivate")
		{
			echo _theme_header($LANG_VARS['user_deactivate']);
			echo("<h2>".$LANG_VARS['user_deactivate']."</h2>");
				
			if(is_user_valid($HTTP_VARS['uid']))
			{
				$return_val = handle_user_deactivate($HTTP_VARS['uid'], $HTTP_VARS, $errors);
				if($return_val === "__CONFIRM__")
				{
					echo get_op_confirm_form(
						$PHP_SELF, 
						replace_lang_vars(array("fullname"=>fetch_user_name($HTTP_VARS['uid']),"user_id"=>$HTTP_VARS['uid']), $LANG_VARS['confirm_user_deactivate']), 
						$HTTP_VARS);
				}
				else if($return_val === "__ABORTED__")
				{
					echo("<div class=\"success\">".$LANG_VARS['user_not_deactivated']."</div>");
					$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&uid=".$HTTP_VARS['uid'],text=>$LANG_VARS['edit_user_info']);
				}
				else if($return_val === TRUE)
				{
					echo("<div class=\"success\">".$LANG_VARS['user_deactivated']."</div>");
				}
				else //if($return_val === FALSE)
				{
					echo format_error_block($errors);
					$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&uid=".$HTTP_VARS['uid'],text=>$LANG_VARS['edit_user_info']);
				}
			}
			else
			{
				echo _theme_error(
						replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_not_found']));
			}
		}
		else if($HTTP_VARS['op'] == "new_user")
		{
			echo _theme_header($LANG_VARS['create_new_user']);
			echo("<h2>".$LANG_VARS['create_new_user']."</h2>");
		
			echo get_user_input_form(NULL,$HTTP_VARS);
		}
		else if ($HTTP_VARS['op'] == "edit")
		{
			if($HTTP_VARS['uid'] == $HTTP_SESSION_VARS['user_id'])
				$page_title = $LANG_VARS['my_info'];
			else
				$page_title = $LANG_VARS['user_info'];
				
			echo _theme_header($page_title);
			echo("<h2>".$page_title."</h2>");

			$user_r = fetch_user_r($HTTP_VARS['uid']);
			if(is_not_empty_array($user_r))
			{
				echo get_user_input_form($user_r,$HTTP_VARS);
			}
			else //user not found.
			{
				echo _theme_error(
						replace_lang_var("user_id", $HTTP_VARS['uid'], $LANG_VARS['user_not_found']));
			}
		}//End of $HTTP_VARS['op'] checks
	}//not an administrator or own user.
	else
	{
		echo _theme_header($LANG_VARS['not_authorized_to_page']);
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}
	
	echo format_footer_links($footer_links_r);
	echo _theme_footer();
}
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
