# ui-dcpreview.tcl --
#
#       UI for preview pane.  Handles drag/drop events which cause
#       decoding/clearing to occur.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import CDcUIVideo

Class CDcUIPreviewFrame

CDcUIPreviewFrame instproc init { appDc uiMain winFrame } {
    $self instvar m_appDc
    $self instvar m_uiMain
    $self instvar m_winFrame
    $self instvar m_iFrameCounter
    $self instvar m_luiPreview

    $self next

    # initialize member variables
    set m_iFrameCounter 0
    set m_luiPreview ""

    # copy arguments to member variables
    set m_appDc $appDc
    set m_uiMain $uiMain
    set m_winFrame $winFrame

    # build the ui
    $self BuildUI
}

CDcUIPreviewFrame instproc BuildUI {} {
    $self instvar m_winFrame

    # the layout of this frame goes like this:
    # Inside the main frame, there are two frames
    # the top frame has a label in it
    # the bottom frame has a column of previews

    # the top frame
    set f [$self get_option smallfont]
    label $m_winFrame.title -text "Preview" -relief ridge -font $f
    pack $m_winFrame.title -side top -fill x


    # the bottom frame
    frame $m_winFrame.preview -relief ridge -borderwidth 2
    pack $m_winFrame.preview -side top -fill both
}

CDcUIPreviewFrame public DropThumbnail { dragNDrop uiThumbnail x y } {
    $self instvar m_winFrame
    $self instvar m_luiPreview
    $self instvar m_uiMain

    # first check if it was dropped within the main window
    if { ![$m_uiMain is_in_window $m_winFrame $x $y] } {
	return 0
    }

    set source [$uiThumbnail set m_source]
    set service [$uiThumbnail set m_service]

    # next we'll check if the uiThumbnail was dropped in a preview window
    foreach uiPreview $m_luiPreview {

	set win [$uiPreview set m_winFrame]
	if { ![$m_uiMain is_in_window $win $x $y] } {
	    continue
	}

	# if it's in the preview window then we should switch the source
	# for this window
	$uiPreview SwitchSource $source $service
	return 1
    }

    # Else we'll have to create a new preview window and add it
    $self instvar m_appDc
    $self instvar m_uiMain
    $self instvar m_iFrameCounter

    # create the frame for the window
    set winFrame [frame $m_winFrame.$m_iFrameCounter]
    pack $m_winFrame.$m_iFrameCounter -side top

    # increment the frame counter
    set m_iFrameCounter [expr "$m_iFrameCounter + 1"]

    set uiPreview [new CDcUIPreview $m_appDc $m_uiMain $self $winFrame \
	    $source $service]

    # add it to the list of review windows
    lappend m_luiPreview $uiPreview

    return 1
}

CDcUIPreviewFrame public RemovePreview { uiPreview } {
    $self instvar m_luiPreview

    # get the preview window
    set winFrame [$uiPreview set m_winFrame]

    # remote it from the list of previews
    set luiNewPreview ""
    foreach uiPreviewTemp $m_luiPreview {
	if { $uiPreview != $uiPreviewTemp } {
	    lappend luiNewPreview $uiPreviewTemp
	}
    }
    set m_luiPreview $luiNewPreview

    # destory the preview
    delete $uiPreview 

    # get the frame for this preview
    destroy $winFrame
}

CDcUIPreviewFrame public getPreviewInfo {} {
    $self instvar m_luiPreview

    set arr(windows) ""
    foreach uiPreview $m_luiPreview {
	lappend arr(windows) $uiPreview
	set source [$uiPreview set m_source]
   	set inetAddr [$source addr]
	set hostname [lookup_host_name $inetAddr]
	set hostname [string tolower $hostname]
	set arr($uiPreview,hostname) $hostname
	set arr($uiPreview,addr) $inetAddr
    }
    set retList [array get arr]
    return $retList
}

#
# Return the CDcUIPreview object containing the source 
#
CDcUIPreviewFrame public GetUIVideoWithSource { source } {
    $self instvar m_luiPreview
    foreach p $m_luiPreview {
	if {[$p GetSource] == $source} {
	    return $p
	}
    }
    return ""
}

Class CDcUIPreview -superclass CDcUIVideo

CDcUIPreview public init { appDc uiMain uiPreviewFrame winFrame \
	source service} {

    $self next $uiMain $winFrame $source $service

    # member variables
    $self instvar m_appDc
    $self instvar m_uiPreviewFrame
    $self instvar m_dragNDrop
    $self instvar m_winFrame

    # store away input
    set m_appDc $appDc
    set m_uiPreviewFrame $uiPreviewFrame
    set m_winFrame $winFrame

    set m_dragNDrop 0

    $self BuildUI
}

CDcUIPreview public StartVideo { } {
    $self next

    $self instvar m_winFrame

    # create and deal with the drag n drop object
    set m_dragNDrop [new DragNDrop $m_winFrame.frame.video.video \
	    "$self DropPreview"]
}

CDcUIPreview public SwitchSource { source service } {
    $self SwitchVideo $source
    $self SwitchService $service
}

CDcUIPreview public DropPreview { dragNDrop x y } {
    $self instvar m_uiMain
    $self instvar m_uiPreviewFrame

    #get the broadcast frame object
    set uiBroadcastFrame [$m_uiMain set m_uiBroadcastFrame]

    # check if it was dropped into the broadcast frame
    if { [$uiBroadcastFrame DropPreview $dragNDrop $self $x $y] } {
	return
    }

    set winFrame [$m_uiPreviewFrame set m_winFrame]

    # check if it was dropped within the main window
    if { ![$m_uiMain is_in_window $winFrame $x $y] } {
	$m_uiPreviewFrame RemovePreview $self
	return
    }

    $dragNDrop zoom_back
}

