/*
 * MB-bitmaps.h --
 *
 *      embedded bitmap declarations
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MB_BITMAPS_H
#define MB_BITMAPS_H

#define Def_Bitmap(name) \
     Tk_DefineBitmap(tcl, Tk_GetUid(#name), \
                     (char*)name##_bits, name##_width, name##_height)

#include "erase.xbm"
#include "unerase.xbm"
#include "copy.xbm"
#include "move.xbm"
#include "freehand.xbm"
#include "line.xbm"
#include "oval.xbm"
#include "rectangle.xbm"
#include "text.xbm"
#include "image.xbm"
#include "updir.xbm"
#include "textfile.xbm"
#include "folder.xbm"
#include "atvobj.xbm"
#include "sep.xbm"
#include "forw.xbm"
#include "back.xbm"

void
MB_LoadBitmaps(Tcl_Interp* tcl)
{
        Def_Bitmap(erase);
        Def_Bitmap(unerase);
        Def_Bitmap(copy);
        Def_Bitmap(move);

        Def_Bitmap(freehand);
        Def_Bitmap(line);
        Def_Bitmap(oval);
        Def_Bitmap(rectangle);
        Def_Bitmap(text);
        Def_Bitmap(image);
        Def_Bitmap(updir);
        Def_Bitmap(textfile);
        Def_Bitmap(folder);
        Def_Bitmap(atvobj);
        Def_Bitmap(sep);
        Def_Bitmap(back);
        Def_Bitmap(forw);
}

#endif /* #ifdef MB-BITMAPS_H */
