# gs.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mps/gs.tcl,v 1.11 2002/02/03 04:27:59 lim Exp $


Class GPSinterp

GPSinterp instproc fork {} {
	#
	# Here's where we hook into the ghostview protocol
	# to pass an X window to ghostscript.
	# We bind the window ID to the environment
	# variable GHOSTVIEW.	We then pass a bunch of
	# information to ghostscript via the "GHOSTVIEW"
	# property on the window indicated here.  One of
	# these attributes is the Drawable, in our case a
	# pixmap ID.  This is handled in setup-property().
	# This API is fragile to say the least.
	#
	$self instvar path_ pswin_ pipe_
	set windowID [winfo id $path_]
	set pixmapID [$pswin_ pixmap-id]
	#
	# setting the Tcl "env" var sets the appropricate value in C,
	# so this value gets correctly transferred into the forked
	# process' environment.  The expr's convert 0x hex form to
	# unsigned decimal.
	#
	global env
	set env(GHOSTVIEW) "[expr $windowID] [expr $pixmapID]"
        puts stderr "\$GHOSTVIEW = $env(GHOSTVIEW)"
#	set env(DISPLAY) :0.0
	$self setup-property
        set failed [catch {
                set pipe_ [open "|gs -dQUIET -dNOPAUSE -dSAFER -dNOPLATFONTS -" w]
        }]

        # set pipe_ [open "|gs -dNOPAUSE -dSAFER -dNOPLATFONTS -" w]
	#
	# Set non-blocking mode on the pipe so we don't hang if gs
	# has a problem.  We only ever write small snippets of
	# ps to the pipe so writes should never block anyway.
	# (The snippets of ps code load the target code from a file.)
	#
        if !{$failed} { fconfigure $pipe_ -blocking false }
}

GPSinterp instproc init pswin {
	$self instvar orient_ pswin_ path_
	set orient_ 0

	#FIXME for now create only a single ps-window

	set pswin_ $pswin
	set path_ [$pswin_ path]
}

GPSinterp instproc kill {} {
    $self instvar pipe_
    if [info exists pipe_] {
        set pid [pid $pipe_]
        $self dump "quit\n"
        catch {flush $pipe_}

        foreach p $pid {
            # REVIEW:
            # for now do this, have to take into account portability
            # later
            exec kill $p
        }
        catch "close $pipe_"
        unset pipe_
    }
}

GPSinterp instproc destroy {} {
    $self instvar pswin_ pipe_
    $pswin_ release
    delete $pswin_
    $self kill

    #NOTE: need to comment out $self next here, otherwise Tcl will crash
    #$self next
}

GPSinterp instproc dump msg {
    $self instvar pipe_
    puts $pipe_ $msg
}

GPSinterp instproc render-file f {
	$self instvar pipe_ first_ pswin_ mwin_
        if ![info exists pipe_] {
                return
        }
	#FIXME FIX THIS
	$pswin_ start
	#
	# Dump a chunk of postscript code to gs:
	#  - nullify $brkpage to avoid problematic "error recovery" code
	#    in framemaker-generated ps
	#  - save a snapshot of the VM in userdict
	#  - map "showpage" to "stop" so we halt the interpreter on the
	#    page boundary
	#  - interpret the file and catch the showpage/stop with
	#    the proc "stopped"
	#  - restore the interpreter state
	#
	$self dump [concat \
{userdict /$brkpage {} put
userdict /_$mash$save save put
userdict /_$realshowpage /showpage load put
userdict /showpage { stop } bind put } \
($f) (r) file cvx stopped pop \
{_$realshowpage grestoreall clear cleardictstack _$mash$save restore}]
	flush $pipe_
        puts stderr "executing render-file $f"
}

#FIXME
GPSinterp instproc width {} {
	$self instvar path_
	return [winfo width $path_]
}

#FIXME
GPSinterp instproc height {} {
	$self instvar path_
	return [winfo height $path_]
}

GPSinterp instproc set-orientation o {
	#FIXME
}

GPSinterp instproc setup-property {} {
	$self instvar orient_ pswin_
        $self instvar bbox_

        if { [info exists bbox_] && "$bbox_"!="" } {
            set w [expr [lindex $bbox_ 2] - [lindex $bbox_ 0]]
            set h [expr [lindex $bbox_ 3] - [lindex $bbox_ 1]]
            set xdpi [expr int(72*[$self width]/$w)]
            set ydpi [expr int(72*[$self height]/$h)]
        } else {
            if $orient_ {
		set w [$self height]
		set h [$self width]
            } else {
		set w [$self width]
		set h [$self height]
            }
            set scaledWidth [expr int(8.5 * 72 + 0.5)]
            set scaledHeight [expr int(11 * 72 + 0.5)]
            # FIXME assume 8.5in width

            set xdpi [expr int($w / 8.5 - 0.5)]
            set ydpi [expr int($h / 11 - 0.5 )]
        }


	#
	# <BackingStoreFlag, Orientation, llx, lly, urx, ury, dpi, dpi>
	# The bounding box coordinates are Postscript style (i.e.,
	# in points, not pixels).
	#
        # use the bounding box if it is there, otherwise use width and height
        if { [info exists bbox_] && "$bbox_"!="" } {
            set s "0 $orient_ $bbox_ $xdpi $ydpi"
        } else {
            set s "0 $orient_ 0 0 $scaledWidth $scaledHeight $xdpi $ydpi"
        }
        puts $s
        #set s "0 $orient_ 0 0 612 792 72 72"
	$pswin_ set-atom GHOSTVIEW $s
}

#FIXME bad name - called when gs finishes rendering page
PostscriptWindow instproc recv-page w {
	# force a redraw
	$self damage
	$self instvar mwin_ path_
	set mwin_ $w
	#FIXME our widget doesn't support tk configuration
	[winfo parent $path_] configure -cursor ""
}

PostscriptWindow instproc init path {
	$self next $path
	$self instvar path_
	set path_ $path
}

PostscriptWindow instproc path {} {
        $self instvar path_
        return $path_
}

PostscriptWindow instproc resize {} {
	$self instvar path_
	puts stderr "resize [winfo width $path_] [winfo height $path_]"
}

#
# Called to prime gs for the next page.
#
PostscriptWindow instproc start {} {
	$self instvar path_
	$self release
	#FIXME our widget doesn't support tk configuration
	puts [[winfo parent $path_] cget -cursor]
	[winfo parent $path_] configure -cursor watch
}

PostscriptWindow instproc release {} {
	$self instvar mwin_
	if [info exists mwin_] {
		#
		# gs is wedged waiting for a NEXT event
		# kick it loose!
		#
                puts stderr "calling next-page"
		$self next-page $mwin_
		unset mwin_
	}
}
