# synch-ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Class SynchSourceUI

SynchSourceUI instproc init {switch src frame} {
    $self instvar switch_;
    $self instvar synch_src_;
    $self instvar frame_;
    $self instvar tscale_;
    $self instvar num_latbars_;

    set switch_ $switch;
    set synch_src_ $src;
    set frame_ $frame;

    set tscale_ 1.5;

    $self instvar l_ c_ lat_lab_;

    set l_ [label $frame.l];
    set c_ [canvas $frame.c -width 150 -height 30];
    set lat_lab_ [label $frame.lat_l];

    $l_ configure -text "[[$src set sess_] set spec_]/[[$src set src_] srcid]";

    pack $l_ -side top;
    pack $c_ -side top;
    pack $lat_lab_ -side top;

    $self instvar latbars_

    set num_latbars_ 10;

    for {set i 0} {$i < $num_latbars_} {incr i} {
	set y1 [expr ((30*$i)/$num_latbars_)];
	set y2 [expr ((30*($i+1))/$num_latbars_)];

	set latbars_($i) [$c_ create rectangle 75 $y1 75 $y2 -fill black -outline black];
    }

    $self instvar last_num_frames_;
    $self instvar last_update_time_;

    set last_update_time_ [clock clicks];
    set last_num_frames_ [$synch_src_ num_frames];

    $self instvar update_period_;
    set update_period_ 500;
    after $update_period_ "$self update_latency";
}

SynchSourceUI instproc update_latency {} {
    $self instvar last_num_frames_ last_update_time_;
    $self instvar synch_src_;

    set lat [$synch_src_ buffer_latency];

    $self instvar l_ lat_lab_ tscale_ c_ latbars_

    set nf [$synch_src_ num_frames];
    set now [clock clicks];

    set fr [expr double($nf - $last_num_frames_) / (double($now - $last_update_time_) / 1000000.0)];
    set last_num_frames_ $nf;
    set last_update_time_ $now;

    $lat_lab_ configure -text "$fr fps :: $lat latency"

    $self instvar num_latbars_;

    for {set i 0} {$i < [expr $num_latbars_ - 1]} {incr i} {
	$c_ move $latbars_($i) 0 [expr 30/$num_latbars_];
    }
    $c_ delete $latbars_([expr $num_latbars_ - 1]);

    for {set i [expr $num_latbars_-1]} {$i > 0} {incr i -1} {
	set latbars_($i) $latbars_([expr $i-1]);
    }

    if {$lat < 0.0} {
	set color red;
    } else {
	set color black;
    }
    set x [expr int((($lat / $tscale_) * 75.0) + 75.0)];

    set latbars_(0) [$c_ create rectangle 75 0 $x [expr 30/$num_latbars_] -fill $color -outline $color];

    $self instvar update_period_;
    after $update_period_ "$self update_latency";
}

Class SynchTransmitterUI

SynchTransmitterUI instproc init {switch xmitter frame} {
    $self instvar switch_ xmitter_ frame_ stype_

    set switch_ $switch;
    set xmitter_ $xmitter;
    set frame_ $frame;

    set stype_ straight

    $self instvar l_ src_b_ switch_type_ src_m_ switch_m_;

    set l_ [label $frame_.l -text "Sink: [$xmitter set spec_]"];

    if {[$xmitter_ set cur_src_] == ""} {
	set src_b_ [menubutton $frame_.mb -text "Source: None" -menu $frame_.mb.m];
    } else {
	set src_b_ [menubutton $frame_.mb -text "Source: [[[$xmitter_ set cur_src_] set sess_] set spec_]" -menu $frame_.mb.m];
    }
    set src_m_ [menu $frame_.mb.m];
    bind $src_b_ <Button-1> "$self make_src_menu; continue";

    set switch_type_ [menubutton $frame_.stype -text "Switch Type: straight" -menu $frame_.stype.m];
    set switch_m_ [menu $frame_.stype.m];
    $switch_m_ add command -label "straight" -command "$switch_type_ configure -text {Switch Type: straight}; $self set stype_ straight;"
    $switch_m_ add command -label "pre prep" -command "$switch_type_ configure -text {Switch Type: pre prep}; $self set stype_ pre_prep;"
    $switch_m_ add command -label "post prep" -command "$switch_type_ configure -text {Switch Type: post prep}; $self set stype_ post_prep;"

    pack $l_ -side top;
    pack $src_b_ -side top;
    pack $switch_type_ -side top;
}

SynchTransmitterUI instproc make_src_menu {} {
    $self instvar xmitter_ switch_ src_m_ src_b_;

    set slist [$switch_ set sources_];

    $src_m_ delete 0 end

    foreach s $slist {
	$src_m_ add command -label "[[$s set sess_] set spec_]" \
	    -command "     \
	    $src_b_ configure -text \"Source: [[$s set sess_] set spec_]\";\
	    $self execute_switch $s;"
    }
}

SynchTransmitterUI instproc execute_switch {src} {
    $self instvar xmitter_ switch_ stype_;

    if {$stype_ == "straight"} {
	$switch_ straight_switch $src $xmitter_;
    } elseif {$stype_ == "pre_prep"} {
	$switch_ prep_switch $src $xmitter_ 1;
    } elseif {$stype_ == "post_prep"} {
	$switch_ switch_prep $src $xmitter_ 1;
    }
}

