/*
 * tracker.h --
 *
 *      Header file for Tracker object which allows camera tracking based
 *      on H261 video input.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TRACKER_H__
#define TRACKER_H__

#include "tclcl.h"

#define BLOCKS_PER_GOB 33
#define NUM_GOBS 12
#define NUM_AREAS 5
#define PAUSE_COUNT 3
#define AREA_SIZE (22 / NUM_AREAS)
#define NUM_HISTS 10

/*
  this keeps information about each macroblock
*/
struct t_block__
{
 int color;
 int x_tl; /* top left x pixel position */
 int y_tl; /* top left y pixel position */
 int x_br; /* bottom right x pixel position */
 int y_br; /* bottom right y pixel position */
 int x_pos;
 int y_pos;
 int changed;
};
typedef struct t_block__ t_block;

/*
  groups of blocks are kept together
*/
struct t_gob__
{
 t_block* blocks;
};
typedef struct t_gob__ t_gob;

class Tracker : public TclObject
{
 public:
  virtual ~Tracker();
  Tracker();
  Tracker(int argc, const char*const* argv);

  void changeBlock(int gob, int block_num);  //  called by t_p64.cc
  int endFrame();  // called by t_decoder-h261.cc
  void refresh();  // not used anymore
  int moveCamera();  // called in tracker.cc
  void lostPackets(int num_lost);  // called by t_decoder-h261.cc
  int getStats();  // called by gui
  void rescale(int newSize);
  virtual int command(int argc, const char* const* argv);  // handles tcl interface

  void print_test();  // just used for development

 private:
  void initGobsArray();

  t_gob gobs[NUM_GOBS];
  char frame_name[40];  // name of the tcl frame to draw into

  int alive_;
  int num_left;
  int num_right;
  int num_center;
  int hist_index;
  int slices[NUM_AREAS];
  int pause_counter;
  int woojblockoff;

  int total_lost;
  int total_pkts;

  int hist_buf[NUM_HISTS];
  int hist_val;
  int tracking_on;
  int num_moves;
};

/*
  this is used to connect tracker to an OTcl class
*/

static class TrackerClass : public TclClass
{
 public:

  TrackerClass() : TclClass("Module/Tracker") {}
  TclObject* create(int argc, const char*const* argv)
  {
    return(new Tracker(argc, argv));
  }

} dm_tracker;

#endif

