/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VERIFY_SUSPECT
extends Protocol
implements Runnable {
    Address local_addr;
    long timeout;
    int num_msgs;
    Vector members;
    Hashtable suspects;
    Thread timer;

    public String getName() {
        return "VERIFY_SUSPECT";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_msgs")) != null) {
            this.num_msgs = new Integer(str);
            if (this.num_msgs <= 0) {
                Trace.warn("VERIFY_SUSPECT.setProperties()", "num_msgs is invalid (" + this.num_msgs + "): setting it to 1");
                this.num_msgs = 1;
            }
            props.remove("num_msgs");
        }
        if (props.size() > 0) {
            System.err.println("VERIFY_SUSPECT.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 9: {
                Address suspected_mbr = (Address)evt.getArg();
                if (suspected_mbr == null) {
                    Trace.error("VERIFY_SUSPECT.up()", "suspected member is null");
                    return;
                }
                this.suspect(suspected_mbr);
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof VerifyHeader)) break;
                VerifyHeader hdr = (VerifyHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        if (hdr.from == null) {
                            Trace.error("VERIFY_SUSPECT.up()", "ARE_YOU_DEAD: hdr.from is null");
                        } else {
                            int i = 0;
                            while (i < this.num_msgs) {
                                Message rsp = new Message(hdr.from, null, null);
                                rsp.putHeader(this.getName(), new VerifyHeader(2, this.local_addr));
                                this.passDown(new Event(1, rsp));
                                ++i;
                            }
                        }
                        return;
                    }
                    case 2: {
                        if (hdr.from == null) {
                            Trace.error("VERIFY_SUSPECT.up()", "I_AM_NOT_DEAD: hdr.from is null");
                            return;
                        }
                        this.unsuspect(hdr.from);
                        return;
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block3: while (this.timer != null && this.suspects.size() > 0) {
            long diff = 0L;
            Hashtable hashtable = this.suspects;
            synchronized (hashtable) {
                Enumeration e = this.suspects.keys();
                while (true) {
                    if (!e.hasMoreElements()) {
                        // MONITOREXIT @DISABLED, blocks:[1, 3, 4, 7] lbl13 : MonitorExitStatement: MONITOREXIT : var8_5
                        if (diff <= 0L) continue block3;
                        break;
                    }
                    Address mbr = (Address)e.nextElement();
                    long val = (Long)this.suspects.get(mbr);
                    long curr_time = System.currentTimeMillis();
                    diff = curr_time - val;
                    if (diff >= this.timeout) {
                        if (Trace.trace) {
                            Trace.info("VERIFY_SUSPECT.run()", "diff=" + diff + ", mbr " + mbr + " is dead (passing up SUSPECT event)");
                        }
                        this.passUp(new Event(9, mbr));
                        this.suspects.remove(mbr);
                        continue;
                    }
                    diff = Math.max(diff, this.timeout - diff);
                }
            }
            Util.sleep(diff);
        }
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void suspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        Hashtable hashtable = this.suspects;
        // MONITORENTER : hashtable
        if (this.suspects.containsKey(mbr)) {
            // MONITOREXIT : hashtable
            return;
        }
        this.suspects.put(mbr, new Long(System.currentTimeMillis()));
        if (Trace.trace) {
            Trace.info("VERIFY_SUSPECT.suspect()", "verifying that " + mbr + " is dead");
        }
        int i = 0;
        while (i < this.num_msgs) {
            Message msg = new Message(mbr, null, null);
            msg.putHeader(this.getName(), new VerifyHeader(1, this.local_addr));
            this.passDown(new Event(1, msg));
            ++i;
        }
        // MONITOREXIT : hashtable
        if (this.timer != null) return;
        this.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unsuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        Hashtable hashtable = this.suspects;
        synchronized (hashtable) {
            if (this.suspects.containsKey(mbr)) {
                if (Trace.trace) {
                    Trace.info("VERIFY_SUSPECT.unsuspect()", "member " + mbr + " is not dead !");
                }
                this.suspects.remove(mbr);
                this.passDown(new Event(51, mbr));
                this.passUp(new Event(51, mbr));
            }
            return;
        }
    }

    void startTimer() {
        if (this.timer == null) {
            this.timer = new Thread((Runnable)this, "VERIFY_SUSPECT.TimerThread");
            this.timer.setDaemon(true);
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer != null && this.timer.isAlive()) {
            Thread tmp = this.timer;
            this.timer = null;
            tmp.interrupt();
            tmp = null;
        }
        this.timer = null;
    }

    private final /* synthetic */ void this() {
        this.local_addr = null;
        this.timeout = 2000L;
        this.num_msgs = 1;
        this.members = null;
        this.suspects = new Hashtable();
        this.timer = null;
    }

    public VERIFY_SUSPECT() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class VerifyHeader
    extends Header {
        static final int ARE_YOU_DEAD = 1;
        static final int I_AM_NOT_DEAD = 2;
        int type;
        Address from;

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[VERIFY_SUSPECT: ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[VERIFY_SUSPECT: I_AM_NOT_DEAD]";
                }
            }
            return "[VERIFY_SUSPECT: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeObject(this.from);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.from = (Address)in.readObject();
        }

        private final /* synthetic */ void this() {
            this.type = 1;
            this.from = null;
        }

        public VerifyHeader() {
            this.this();
        }

        VerifyHeader(int type) {
            this.this();
            this.type = type;
        }

        VerifyHeader(int type, Address from) {
            this(type);
            this.from = from;
        }
    }
}

