//
// C++ Interface: tagitem.h
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
// The first version of this file was generated by umbrello 
// on Tue May 18 2004 at 20:55:55

#ifndef __TAGITEM_H_2004_05_18
#define __TAGITEM_H_2004_05_18

#include <string>

using namespace std;

// Class TagItem
// 
// 
class TagItem {
/**
 * Public stuff
 */
public:
	/**
	 * Fields
	 */
	/**
	 * 
	 */
	/**
	 * Constructors
	 */
	/**
	 * Empty Constructor
	 */
	TagItem() { }

	/** @returns the parent tag belonging to the given tagname. The tagname must be of the format
	  * parentTag::lastTag and parentTag will be returned.\n
	  * If no parent exists, i.e. no :: is available, the empty string is returned.
	  * @pre tagname must not contain a single : */
	static string getParent(const string& tagname);
	/** @returns the short name of the tag, i.e. reduced by its parents. Returns the whole string if
	  * no parent is in the string (i.e. it contains no ::)
	  * @pre tagname must not contain a single :
	  * @pre : must not be the last character 
	  */
	static string getShortname(const string& tagname);

	/**
	 * Accessor Methods
	 */
	/** @returns the full name of the tag, this should be unique. */
	virtual const string& fullTagname() const = 0;
	/** @returns a short name for the tag. It might be the same as fullTagName. */
	virtual string shortTagname() const	{ return getShortname(fullTagname()); };;
	/** @returns the description of the item */
	virtual const string& description() const = 0;
	/**
	 * Operations
	 */
	/** Compares if the objects fullTagname matches the handed one.
	  * 
	  * @param fullTagname_ value to compare against */
	virtual bool operator==(const string& fullTagname_) const	
	{ return fullTagname()==fullTagname_; };
	/** Compares if the two objects equals.
	  * 
	  * @param tagItem object to compare against */
	virtual bool operator==(const TagItem& tagItem) const
	{ return fullTagname() == tagItem.fullTagname(); };

	/** @brief Filters the item against the given pattern.
	  *
	  * Checks if the fullTagname() of the item matches the pattern. Recureses in any subitems.
	  * Items that match might make themselves visible, e.g. by expanding a tree.
	  * @param pattern to be searched for
	  * @returns if the pattern was found in the item or recursivly in any subitem
	  */
	virtual bool filterByName(const string& pattern) = 0;
};

#endif 	// __TAGITEM_H_2004_05_18

