/*
    Copyright (c) 1998, 1999, 2000, 2001, 2003, 2004 Benhur Stein
    
    This file is part of Paj.

    Paj is free software; you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    Paj is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
    for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Paj; if not, write to the Free Software Foundation, Inc.,
    59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef _Shape_h_
#define _Shape_h_

// Paje
// ----
// Shape.h
// shape drawing functions and classes.

// 19.ago.2004 BS  creation


#include <Foundation/Foundation.h>
#include "../General/Protocols.h"

typedef     void (shapefunction)(float x, float y, float w, float h);
typedef     void (drawfunction)(void);

@interface ShapeFunction : NSObject
{
    shapefunction *function;
    NSString *name;
    float topExtension;
    float rightExtension;
} 

+ (ShapeFunction *)shapeFunctionWithName:(NSString *)name;
+ (NSArray *)shapeFunctionsForDrawingType:(PajeDrawingType)drawingType;
+ (ShapeFunction *)shapeFunctionWithFunction:(shapefunction *)f
                                        name:(NSString *)n;
+ (ShapeFunction *)shapeFunctionWithFunction:(shapefunction *)f
                                        name:(NSString *)n
                                topExtension:(float)top
                              rightExtension:(float)right;

- (id)initWithShapeFunction:(shapefunction *)f
                       name:(NSString *)n
               topExtension:(float)top
             rightExtension:(float)right;

- (shapefunction *)function;
- (NSString *)name;
- (float)topExtension;
- (float)rightExtension;

@end

@interface DrawFunction : NSObject
{
    drawfunction *function;
    NSString *name;
} 

+ (DrawFunction *)drawFunctionWithName:(NSString *)name;
+ (NSArray *)drawFunctions;

+ (DrawFunction *)drawFunctionWithFunction:(drawfunction *)f
                                      name:(NSString *)n;

- (id)initWithDrawFunction:(drawfunction *)f name:(NSString *)n;

- (drawfunction *)function;
- (NSString *)name;

@end

#endif
