/* vector.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscfix.h"
#include "petscvec.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecprinthelp_ PVECPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecprinthelp_ pvecprinthelp
#else
#define vecprinthelp_ pvecprinthelp_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecprinthelp_ VECPRINTHELP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecprinthelp_ vecprinthelp
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetsizes_ PVECSETSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetsizes_ pvecsetsizes
#else
#define vecsetsizes_ pvecsetsizes_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetsizes_ VECSETSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetsizes_ vecsetsizes
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetblocksize_ PVECSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetblocksize_ pvecsetblocksize
#else
#define vecsetblocksize_ pvecsetblocksize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetblocksize_ VECSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetblocksize_ vecsetblocksize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecgetblocksize_ PVECGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetblocksize_ pvecgetblocksize
#else
#define vecgetblocksize_ pvecgetblocksize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecgetblocksize_ VECGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetblocksize_ vecgetblocksize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecvalid_ PVECVALID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecvalid_ pvecvalid
#else
#define vecvalid_ pvecvalid_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecvalid_ VECVALID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecvalid_ vecvalid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecdot_ PVECDOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecdot_ pvecdot
#else
#define vecdot_ pvecdot_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecdot_ VECDOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecdot_ vecdot
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecnorm_ PVECNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecnorm_ pvecnorm
#else
#define vecnorm_ pvecnorm_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecnorm_ VECNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecnorm_ vecnorm
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecnormalize_ PVECNORMALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecnormalize_ pvecnormalize
#else
#define vecnormalize_ pvecnormalize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecnormalize_ VECNORMALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecnormalize_ vecnormalize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecmin_ PVECMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmin_ pvecmin
#else
#define vecmin_ pvecmin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecmin_ VECMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmin_ vecmin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vectdot_ PVECTDOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vectdot_ pvectdot
#else
#define vectdot_ pvectdot_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vectdot_ VECTDOT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vectdot_ vectdot
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecscale_ PVECSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecscale_ pvecscale
#else
#define vecscale_ pvecscale_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecscale_ VECSCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecscale_ vecscale
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define veccopy_ PVECCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define veccopy_ pveccopy
#else
#define veccopy_ pveccopy_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define veccopy_ VECCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define veccopy_ veccopy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecset_ PVECSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecset_ pvecset
#else
#define vecset_ pvecset_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecset_ VECSET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecset_ vecset
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecaxpy_ PVECAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaxpy_ pvecaxpy
#else
#define vecaxpy_ pvecaxpy_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecaxpy_ VECAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaxpy_ vecaxpy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecaxpby_ PVECAXPBY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaxpby_ pvecaxpby
#else
#define vecaxpby_ pvecaxpby_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecaxpby_ VECAXPBY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaxpby_ vecaxpby
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecaypx_ PVECAYPX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaypx_ pvecaypx
#else
#define vecaypx_ pvecaypx_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecaypx_ VECAYPX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecaypx_ vecaypx
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecswap_ PVECSWAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecswap_ pvecswap
#else
#define vecswap_ pvecswap_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecswap_ VECSWAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecswap_ vecswap
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecwaxpy_ PVECWAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwaxpy_ pvecwaxpy
#else
#define vecwaxpy_ pvecwaxpy_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecwaxpy_ VECWAXPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecwaxpy_ vecwaxpy
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpointwisemult_ PVECPOINTWISEMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpointwisemult_ pvecpointwisemult
#else
#define vecpointwisemult_ pvecpointwisemult_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpointwisemult_ VECPOINTWISEMULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpointwisemult_ vecpointwisemult
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpointwisedivide_ PVECPOINTWISEDIVIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpointwisedivide_ pvecpointwisedivide
#else
#define vecpointwisedivide_ pvecpointwisedivide_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpointwisedivide_ VECPOINTWISEDIVIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpointwisedivide_ vecpointwisedivide
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecmaxpointwisedivide_ PVECMAXPOINTWISEDIVIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmaxpointwisedivide_ pvecmaxpointwisedivide
#else
#define vecmaxpointwisedivide_ pvecmaxpointwisedivide_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecmaxpointwisedivide_ VECMAXPOINTWISEDIVIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmaxpointwisedivide_ vecmaxpointwisedivide
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetvalues_ PVECSETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvalues_ pvecsetvalues
#else
#define vecsetvalues_ pvecsetvalues_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetvalues_ VECSETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvalues_ vecsetvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetvaluesblocked_ PVECSETVALUESBLOCKED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvaluesblocked_ pvecsetvaluesblocked
#else
#define vecsetvaluesblocked_ pvecsetvaluesblocked_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetvaluesblocked_ VECSETVALUESBLOCKED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvaluesblocked_ vecsetvaluesblocked
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetlocaltoglobalmapping_ PVECSETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetlocaltoglobalmapping_ pvecsetlocaltoglobalmapping
#else
#define vecsetlocaltoglobalmapping_ pvecsetlocaltoglobalmapping_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetlocaltoglobalmapping_ VECSETLOCALTOGLOBALMAPPING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetlocaltoglobalmapping_ vecsetlocaltoglobalmapping
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetlocaltoglobalmappingblock_ PVECSETLOCALTOGLOBALMAPPINGBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetlocaltoglobalmappingblock_ pvecsetlocaltoglobalmappingblock
#else
#define vecsetlocaltoglobalmappingblock_ pvecsetlocaltoglobalmappingblock_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetlocaltoglobalmappingblock_ VECSETLOCALTOGLOBALMAPPINGBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetlocaltoglobalmappingblock_ vecsetlocaltoglobalmappingblock
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetvalueslocal_ PVECSETVALUESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvalueslocal_ pvecsetvalueslocal
#else
#define vecsetvalueslocal_ pvecsetvalueslocal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetvalueslocal_ VECSETVALUESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvalueslocal_ vecsetvalueslocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetvaluesblockedlocal_ PVECSETVALUESBLOCKEDLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvaluesblockedlocal_ pvecsetvaluesblockedlocal
#else
#define vecsetvaluesblockedlocal_ pvecsetvaluesblockedlocal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetvaluesblockedlocal_ VECSETVALUESBLOCKEDLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetvaluesblockedlocal_ vecsetvaluesblockedlocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecassemblybegin_ PVECASSEMBLYBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecassemblybegin_ pvecassemblybegin
#else
#define vecassemblybegin_ pvecassemblybegin_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecassemblybegin_ VECASSEMBLYBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecassemblybegin_ vecassemblybegin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecassemblyend_ PVECASSEMBLYEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecassemblyend_ pvecassemblyend
#else
#define vecassemblyend_ pvecassemblyend_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecassemblyend_ VECASSEMBLYEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecassemblyend_ vecassemblyend
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecviewfromoptions_ PVECVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecviewfromoptions_ pvecviewfromoptions
#else
#define vecviewfromoptions_ pvecviewfromoptions_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecviewfromoptions_ VECVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecviewfromoptions_ vecviewfromoptions
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecgetsize_ PVECGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetsize_ pvecgetsize
#else
#define vecgetsize_ pvecgetsize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecgetsize_ VECGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetsize_ vecgetsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecgetlocalsize_ PVECGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetlocalsize_ pvecgetlocalsize
#else
#define vecgetlocalsize_ pvecgetlocalsize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecgetlocalsize_ VECGETLOCALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecgetlocalsize_ vecgetlocalsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetoption_ PVECSETOPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetoption_ pvecsetoption
#else
#define vecsetoption_ pvecsetoption_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetoption_ VECSETOPTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetoption_ vecsetoption
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecplacearray_ PVECPLACEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecplacearray_ pvecplacearray
#else
#define vecplacearray_ pvecplacearray_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecplacearray_ VECPLACEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecplacearray_ vecplacearray
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecresetarray_ PVECRESETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecresetarray_ pvecresetarray
#else
#define vecresetarray_ pvecresetarray_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecresetarray_ VECRESETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecresetarray_ vecresetarray
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecreciprocal_ PVECRECIPROCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecreciprocal_ pvecreciprocal
#else
#define vecreciprocal_ pvecreciprocal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecreciprocal_ VECRECIPROCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecreciprocal_ vecreciprocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetstashinitialsize_ PVECSETSTASHINITIALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetstashinitialsize_ pvecsetstashinitialsize
#else
#define vecsetstashinitialsize_ pvecsetstashinitialsize_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsetstashinitialsize_ VECSETSTASHINITIALSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsetstashinitialsize_ vecsetstashinitialsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstashview_ PVECSTASHVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstashview_ pvecstashview
#else
#define vecstashview_ pvecstashview_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecstashview_ VECSTASHVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecstashview_ vecstashview
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL vecprinthelp_(Vec vec, int *ierr ){
*ierr = VecPrintHelp(
	(Vec)PetscToPointer( (vec) ));
}
void PETSC_STDCALL vecsetsizes_(Vec v,int *n,int *N, int *ierr ){
*ierr = VecSetSizes(
	(Vec)PetscToPointer( (v) ),*n,*N);
}
void PETSC_STDCALL vecsetblocksize_(Vec v,int *bs, int *ierr ){
*ierr = VecSetBlockSize(
	(Vec)PetscToPointer( (v) ),*bs);
}
void PETSC_STDCALL vecgetblocksize_(Vec v,int *bs, int *ierr ){
*ierr = VecGetBlockSize(
	(Vec)PetscToPointer( (v) ),bs);
}
void PETSC_STDCALL vecvalid_(Vec v,PetscTruth *flg, int *ierr ){
*ierr = VecValid(
	(Vec)PetscToPointer( (v) ),flg);
}
void PETSC_STDCALL vecdot_(Vec x,Vec y,PetscScalar *val, int *ierr ){
*ierr = VecDot(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),val);
}
void PETSC_STDCALL vecnorm_(Vec x,NormType *type,PetscReal *val, int *ierr ){
*ierr = VecNorm(
	(Vec)PetscToPointer( (x) ),*type,val);
}
void PETSC_STDCALL vecnormalize_(Vec x,PetscReal *val, int *ierr ){
*ierr = VecNormalize(
	(Vec)PetscToPointer( (x) ),val);
}
void PETSC_STDCALL vecmin_(Vec x,int *p,PetscReal *val, int *ierr ){
*ierr = VecMin(
	(Vec)PetscToPointer( (x) ),p,val);
}
void PETSC_STDCALL vectdot_(Vec x,Vec y,PetscScalar *val, int *ierr ){
*ierr = VecTDot(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),val);
}
void PETSC_STDCALL vecscale_( PetscScalar *alpha,Vec x, int *ierr ){
*ierr = VecScale(alpha,
	(Vec)PetscToPointer( (x) ));
}
void PETSC_STDCALL veccopy_(Vec x,Vec y, int *ierr ){
*ierr = VecCopy(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void PETSC_STDCALL vecset_( PetscScalar *alpha,Vec x, int *ierr ){
*ierr = VecSet(alpha,
	(Vec)PetscToPointer( (x) ));
}
void PETSC_STDCALL vecaxpy_( PetscScalar *alpha,Vec x,Vec y, int *ierr ){
*ierr = VecAXPY(alpha,
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void PETSC_STDCALL vecaxpby_( PetscScalar *alpha, PetscScalar *beta,Vec x,Vec y, int *ierr ){
*ierr = VecAXPBY(alpha,beta,
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void PETSC_STDCALL vecaypx_( PetscScalar *alpha,Vec x,Vec y, int *ierr ){
*ierr = VecAYPX(alpha,
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void PETSC_STDCALL vecswap_(Vec x,Vec y, int *ierr ){
*ierr = VecSwap(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void PETSC_STDCALL vecwaxpy_( PetscScalar *alpha,Vec x,Vec y,Vec w, int *ierr ){
*ierr = VecWAXPY(alpha,
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),
	(Vec)PetscToPointer( (w) ));
}
void PETSC_STDCALL vecpointwisemult_(Vec x,Vec y,Vec w, int *ierr ){
*ierr = VecPointwiseMult(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),
	(Vec)PetscToPointer( (w) ));
}
void PETSC_STDCALL vecpointwisedivide_(Vec x,Vec y,Vec w, int *ierr ){
*ierr = VecPointwiseDivide(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),
	(Vec)PetscToPointer( (w) ));
}
void PETSC_STDCALL vecmaxpointwisedivide_(Vec x,Vec y,PetscReal *max, int *ierr ){
*ierr = VecMaxPointwiseDivide(
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ),max);
}
void PETSC_STDCALL vecsetvalues_(Vec x,int *ni, int ix[], PetscScalar y[],InsertMode *iora, int *ierr ){
*ierr = VecSetValues(
	(Vec)PetscToPointer( (x) ),*ni,ix,y,*iora);
}
void PETSC_STDCALL vecsetvaluesblocked_(Vec x,int *ni, int ix[], PetscScalar y[],InsertMode *iora, int *ierr ){
*ierr = VecSetValuesBlocked(
	(Vec)PetscToPointer( (x) ),*ni,ix,y,*iora);
}
void PETSC_STDCALL vecsetlocaltoglobalmapping_(Vec x,ISLocalToGlobalMapping *mapping, int *ierr ){
*ierr = VecSetLocalToGlobalMapping(
	(Vec)PetscToPointer( (x) ),*mapping);
}
void PETSC_STDCALL vecsetlocaltoglobalmappingblock_(Vec x,ISLocalToGlobalMapping *mapping, int *ierr ){
*ierr = VecSetLocalToGlobalMappingBlock(
	(Vec)PetscToPointer( (x) ),*mapping);
}
void PETSC_STDCALL vecsetvalueslocal_(Vec x,int *ni, int ix[], PetscScalar y[],InsertMode *iora, int *ierr ){
*ierr = VecSetValuesLocal(
	(Vec)PetscToPointer( (x) ),*ni,ix,y,*iora);
}
void PETSC_STDCALL vecsetvaluesblockedlocal_(Vec x,int *ni, int ix[], PetscScalar y[],InsertMode *iora, int *ierr ){
*ierr = VecSetValuesBlockedLocal(
	(Vec)PetscToPointer( (x) ),*ni,ix,y,*iora);
}
void PETSC_STDCALL vecassemblybegin_(Vec vec, int *ierr ){
*ierr = VecAssemblyBegin(
	(Vec)PetscToPointer( (vec) ));
}
void PETSC_STDCALL vecassemblyend_(Vec vec, int *ierr ){
*ierr = VecAssemblyEnd(
	(Vec)PetscToPointer( (vec) ));
}
void PETSC_STDCALL vecviewfromoptions_(Vec vec,char *title, int *ierr ){
*ierr = VecViewFromOptions(
	(Vec)PetscToPointer( (vec) ),title);
}
void PETSC_STDCALL vecgetsize_(Vec x,int *size, int *ierr ){
*ierr = VecGetSize(
	(Vec)PetscToPointer( (x) ),size);
}
void PETSC_STDCALL vecgetlocalsize_(Vec x,int *size, int *ierr ){
*ierr = VecGetLocalSize(
	(Vec)PetscToPointer( (x) ),size);
}
void PETSC_STDCALL vecsetoption_(Vec x,VecOption *op, int *ierr ){
*ierr = VecSetOption(
	(Vec)PetscToPointer( (x) ),*op);
}
void PETSC_STDCALL vecplacearray_(Vec vec, PetscScalar array[], int *ierr ){
*ierr = VecPlaceArray(
	(Vec)PetscToPointer( (vec) ),array);
}
void PETSC_STDCALL vecresetarray_(Vec vec, int *ierr ){
*ierr = VecResetArray(
	(Vec)PetscToPointer( (vec) ));
}
void PETSC_STDCALL vecreciprocal_(Vec vec, int *ierr ){
*ierr = VecReciprocal(
	(Vec)PetscToPointer( (vec) ));
}
void PETSC_STDCALL vecsetstashinitialsize_(Vec vec,int *size,int *bsize, int *ierr ){
*ierr = VecSetStashInitialSize(
	(Vec)PetscToPointer( (vec) ),*size,*bsize);
}
void PETSC_STDCALL vecstashview_(Vec v,PetscViewer *viewer, int *ierr ){
*ierr = VecStashView(
	(Vec)PetscToPointer( (v) ),*viewer);
}
#if defined(__cplusplus)
}
#endif
