--TEST--
maxdb fetch bigint values
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 fixed(30) default 5,
                                                     c2 fixed(30),
                                                     c3 fixed(30) not NULL,
                                                     c4 fixed(30),
                                                     c5 fixed(30),
                                                     c6 fixed(30),
                                                     c7 fixed(30))");

	maxdb_query($link, "INSERT INTO test_bind_fetch (c2,c3,c4,c5,c6,c7) VALUES (-23,4.0,33333333333333,0,-333333333333,99.9)");

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_fetch");
	maxdb_bind_result($stmt, $c1, $c2, $c3, $c4, $c5, $c6, $c7);
	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test = array($c1,$c2,$c3,$c4,$c5,$c6,$c7);

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
array(7) {
  [0]=>
  int(5)
  [1]=>
  int(-23)
  [2]=>
  int(4)
  [3]=>
  string(14) "33333333333333"
  [4]=>
  int(0)
  [5]=>
  string(13) "-333333333333"
  [6]=>
  int(100)
}
