--TEST--
maxdb_stmt_execute_oo
--SKIPIF--
<?php require 'skipifoo.inc'; ?>
--FILE--
<?php
$maxdb = new maxdb("localhost", "MONA", "RED", "DEMODB");
   
/* check connection */
if (maxdb_connect_errno()) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}
   
$maxdb->query("CREATE TABLE temp.mycity LIKE hotel.city");
 
/* Prepare an insert statement */
$query = "INSERT INTO temp.mycity (zip, name, state) VALUES (?,?,?)";
$stmt = $maxdb->prepare($query);

$stmt->bind_param("sss", $val1, $val2, $val3);

$val1 = '11111';
$val2 = 'Georgetown';
$val3 = 'NY';
   
/* Execute the statement */
$stmt->execute();

$val1 = '22222';
$val2 = 'Hubbatown';
$val3 = 'CA';
   
/* Execute the statement */
$stmt->execute();

/* close statement */
$stmt->close();

/* retrieve all rows from myCity */
$query = "SELECT zip, name, state FROM temp.mycity";
if ($result = $maxdb->query($query)) {
   while ($row = $result->fetch_row()) {
       printf("%s (%s,%s)\n", $row[0], $row[1], $row[2]);
   }
   /* free result set */
   $result->close();
}

/* remove table */
$maxdb->query("DROP TABLE temp.mycity");

/* close connection */    
$maxdb->close(); 
?>
--EXPECT--
11111 (Georgetown,NY)
22222 (Hubbatown,CA)
