//-----------------------------------------------------------------------------
//
//	PICSTART Plus programming interface
//
//-----------------------------------------------------------------------------
//
//	Cosmodog, Ltd.
//	415 West Huron Street
//	Chicago, IL   60610
//	http://www.cosmodog.com
//
//-----------------------------------------------------------------------------

#ifndef __PICDEV_H_
#define __PICDEV_H_

// indices into processor definition arrays
//
#define	PD_PGM_SIZEH	0		// size of the program space, in words
#define	PD_PGM_SIZEL	1
#define	PD_PGM_WIDTHH	2		// width of address word
#define	PD_PGM_WIDTHL	3
#define	PD_DATA_WIDTHH	4		// width of data word
#define	PD_DATA_WIDTHL	5
								// 6-25: meaning unknown
// One of these words is a bit mask for the configuration bits.
// It is not known at this time which is correct--the two words
// always have the same value.
// Until I can determine which is which, the first word will be
// deemed to define the width of the config word, and the
// second will be deemed the mask.
// 15 Apr 2004 - JLP
#define	PD_CFG_WIDTHH	10
#define	PD_CFG_WIDTHL	11
#define	PD_CFG_MASKH	12
#define	PD_CFG_MASKL	13

#define	PD_ID_ADDRH		26		// Address of ID Locations Area
#define	PD_ID_ADDRL		25
#define	PD_ID_SIZE		28		// Size of ID Locations Area

#define	PD_CFG_ADDRH	29		// address of the configuration bits
#define	PD_CFG_ADDRL	30
#define	PD_CFG_SIZE		31		// 31: meaning unknown (size of config register?)
#define	PD_DATA_ADDRH	32		// address of data space? (always seems to be zero)
#define	PD_DATA_ADDRL	33
#define	PD_DATA_SIZEH	34		// EEPROM data space size, in bytes
#define	PD_DATA_SIZEL	35
#define	PD_CLK_ADDRH	36		// address of clock calibration space
#define	PD_CLK_ADDRL	37
#define	PD_CLK_SIZEH	38		// size of clock calibration space, in words
#define	PD_CLK_SIZEL	39
								// 40-43: meaning unknown

#define	PICDEV_DEFSIZE		44		// profile is 44 bytes long
#define	PICDEV_DEFXSIZE	32		// extended profile is 32 bytes long

typedef struct
{
	const char *name;						// name of the device
	const unsigned char *def;			// definition (initialization) (always 44 bytes long)
	const unsigned char *defx;			// extended definition (initialization) (always 16 bytes long)
	const unsigned short int cpbits;	// set of code protection bits in configuration word (0 = read protected)
	const unsigned short int wdbit;	// watchdog enable bit in configuration word (1 = enabled)

	// Additions below by Alexandre Nunes
	// If set, these values override those guessed from the header.
	const unsigned short int wordalign;	// Word alignment for writing to this device.
	const unsigned int cfgmem;		// Configuration Memory Start addr
	const unsigned int idaddr;		// Address of ID Locations area
	const unsigned short int idsize;
	const unsigned int eeaddr;		// Data EEPROM address
	// More to come.
} PIC_DEFINITION;

// return codes from blank check
//
#define BLANK_PGM		0x01		// 0 = program memory blank
#define BLANK_CFG		0x02		// 0 = configuration bits blank
#define BLANK_ID		0x04		// 0 = ID locations blank
#define BLANK_DATA	0x08		// 0 = EEPROM data blank

extern const PIC_DEFINITION *deviceList[];

#endif // defined __PICDEV_H_
