/*
Config.h
*/

/*
WARNING: If you change any path, you will must
         change accordly Makefile install section.
*/

#ifndef __CONFIG_H
#define __CONFIG_H

#define RELPREFIX ""
//#define RELPREFIX "2"
#define POSTMANNAME "postman"
#define INTERDAEMONNAME "interdaemon"
#define APPNAME POSTMANNAME""RELPREFIX
#define DAEMONNAME INTERDAEMONNAME""RELPREFIX
#define PROGNAME DAEMONNAME

//Web Directory for app icons, help and html pages.
// ----> BE SURE TO SET THIS LINE
#define HTDOCDIR "/usr/local/apache/htdocs/"APPNAME

#if defined (LINUX)        
typedef unsigned char xuchar;
typedef unsigned int xuint;
typedef signed int xsint;
typedef unsigned long xulong;
#define cmdSORT "/usr/bin/sort"
#define PS   "/bin/ps"
#define GREP "/bin/grep"
#define WC   "/usr/bin/wc"
#elif defined (HP)
#define bool int
#define false  0
#define true   1
typedef int socklen_t;
typedef unsigned char xuchar;
typedef unsigned int xuint;
typedef int xsint;
typedef unsigned long xulong;
#define cmdSORT "/usr/bin/sort"
#define PS   "/usr/bin/ps"
#define GREP "/usr/bin/grep"
#define WC   "/usr/bin/wc"
#elif defined (SUN)
#define bool int
#define false  0
#define true   1
//typedef int socklen_t;
typedef unsigned char xuchar;
typedef unsigned int xuint;
typedef int xsint;
typedef unsigned long xulong;
#define cmdSORT "/bin/sort"
#define PS   "/bin/ps"
#define GREP "/bin/grep"
#define WC   "/usr/bin/wc"
#endif

//UNDEF or comment if your system have not that function.
#define HAVE_VSNPRINTF

#define PATH_CGI          "/cgi-bin/"APPNAME
#define HOMEPAGE_SPA      HTDOCDIR"/"APPNAME"_spa.html"
#define HOMEPAGE_VAL      HTDOCDIR"/"APPNAME"_val.html"
#define HOMEPAGE_ENG      HTDOCDIR"/"APPNAME"_eng.html"
#define HOMEPAGE_EUS      HTDOCDIR"/"APPNAME"_eus.html"

#define APP_VERSION "2.0"

#define MAILCAP                      "/usr/local/etc/"APPNAME".mailcap"
#define FILE_FOR_NO_ACCEPT_NEW_CONNS "/usr/local/etc/"APPNAME".disabled"
#define SERVICE_DISABLED             "/usr/local/etc/%s.disabled"

//WARNINGS: DO NO PUT SLASH AT THE END OF THE PATHS!
//          DIRECTORIES MUST BE EXISTS!

#define BASEDIR             "/var/"APPNAME
#define UNIX_SOCKETS_PATH   BASEDIR"/server"
#define PIDDIR              BASEDIR"/server"
#define NETNEWS_PATH        BASEDIR"/netnews"
#define NN_DEFAULTGROUPS    NETNEWS_PATH"/defaultgroups"
#define DATABASES_PATH      BASEDIR"/databases"
#define SOCK_SESSIONS_PATH  BASEDIR"/sessions"
#define LOCKSDIR            BASEDIR"/locks"
#define TMP                 BASEDIR"/tmp"
#define UMASK               077
#define USERDIRMODE         0710
#define USERATTACHSDIRMODE  0770
#define CONVERTUSERNAMETOLOWERCASE 1

//IF YOU USE c-client RELEASE 4.7 OR LESS DEFINE THE NEXT LINE
//#define C_CLIENT_4_7

//1 Allow several connections from the same user using that program, 0 only one
#define ALLOW_SEVERAL_CONNS 0

//in seconds, read in lock file.
#define MAX_TIME_BETWEEN_CONNS 5
//in seconds
#define IMAP_TIMEOUT 60

//in bytes
#define SOCKETSIZE 4096

//Counter of the interdaemon child. Only is used when the signal RELOAD is sent to the parent process.
#define TMPSERVERCOUNT "/tmp/servercount"
#define CMDNUMCHILDS PS" -e | "GREP" interdaemon | "WC" -l > "TMPSERVERCOUNT

//***** DEFAULT OPTIONS ********************
#define DEFOPT_INSERTSIGNATUREINNEWMSG 0
//0 display all msgs in one page
#define DEFOPT_MSGSPERINDEXPAGE        10
#define DEFOPT_SAVEMSGSENTMAIL         1
#define DEFOPT_DISPLAYPERSONALINFO     1
#define DEFOPT_WIDTHWRITEAREA          72
#define DEFOPT_HEIGHTWRITEAREA         20
#define DEFOPT_TRUNCATELENGTHREADINGMSG 80
#define DEFOPT_REPLYFROM               0
#define DEFOPT_FORW_ATTACHS            1
#define DEFOPT_SENTMAILBOX             "sent-mail"
#define MAXNUMATTACHSINSEND            30
#define DEFOPT_REFRESHTIME             0
#define DEFOPT_SHOWCLOCK               0
#define DEFOPT_CONFIRMPURGE            1
#define DEFOPT_CONFIRMLOGOUT           1
#define DEFOPT_SKIN                    "DEFAULT"
#define DEFOPT_NNTPSERVER              "news"
#define DEFOPT_SHOWICONSLABELS         1
#define DEFOPT_ICONSSIZE               0
//(in bytes)
#define MAXTEXTSIZEATTACHFORDISPLAY    10000

//***** WWW ABSOLUTE DIRECTORIES ************************
#define PATH_IMAGENS      "/"APPNAME"/icons"
     
//NNTP options
//Force include default nntp groups in all users.
#define FORCE_INCLUDE_NNTP_SUBSCRIBEDGROUPS 1
//Show a warning in COmpose Message page
#define SHOW_NNTP_SEND_WARNING 1
//In seconds. Max time to refresh the full nttp groups of one server.
#define MAX_TIME_NNFILE 86400
//MAX NNTP GROUPS FOUND
#define MAX_NNTP_GROUPS_FOUND 1000
//BEGIN FILTER FOR NNTP GROUP SEARCH
#define BEGIN_FILTER_NNTP_SEARCH "es.*"
//NNTP Group to enter (Valencia University specific setup)
#define DEFAULTBEGINNNTPGROUP "local.anuncios"
//Sort the NNTP All groups file when this is got (with system prog sort).
#define SORT_NNTP_ALLGROUPS 1

//***** MISC ********************************************
//Default mailbox to display when logging if cgi env var "beginmailbox" is not defined.
#define DEFAULTBEGINMAILBOX "INBOX"
//We do not allow html attachs parameters overwrite our html parameters.
//  by example <HTML>,<BODY,</BODY></HTML>
#define DISABLE_ATT_HTML_TOKENS 1
//User can change the field "From:" composing a message.
#define USERCANCHANGEFROM 0
//for display the time (hh:ss) for msgs in the message index
#define DISPLAY_MSG_TIME_IN_INDEX 1
//for use arrival date or subject date
#define USE_ARRIVAL_DATE 1
//in seconds
#define DEFTIMEOUT 1200
#define DEFIMAPPORT 143
#define DEFNNTPPORT 119
#define DEFSMTPPORT 25
#define DEFSIEVEPORT 2000
#define DEFFORWARDPORT 106
#define DEFPOPPASSPORT 106
#define USETIMEOUT 1
#define CONFIRM_DELETEMAILBOX 1
#define SIGNATURENAME   ".signature"
#define SIEVENAME ".sieve"
#define USEROPTIONSNAME ".options"
#define USERADDRESSBOOKNAME ".addressbook"
#define SUBSCRIBEDGROUPSNAME ".subscribedgroups"
#define RCGROUPSNAME ".newsrc"
#define DEFCOLOR_BGTABLE "#CCCCCC"
#define DEFCOLOR_BGTABLECOPYRIGHT "#CCCCCC"
#define DEFCOLOR_BGBOTONERACOLOR "#CCCCCC"
#define SAVEDINCOMPOSE ".savedmsg"
#define SAVEDNNTPINCOMPOSE ".savednntpmsg"
#define TABLEFACEFONT "Arial,PrimaSans BT,Verdana,sans-serif"
#define MAINSIZEFONT 2
#define STATUSFACEFONT "Arial,PrimaSans BT,Verdana,sans-serif"
#define MAINCOLORFONT "#000000"
#define LENGTHBOUNDARY 50
#define AVOID_IMAP_MSG_MAILBOXVULNERABLE
//in minutes
#define MIN_TIME_TO_REFRESH 1
#define XMAILER APPNAME" "APP_VERSION
//#define THECHARSET "US-ASCII"
#define THECHARSET "ISO-8859-1"
#define CUTINDICATOR "..."
#define CALCULATEMAILBOXSIZE 1
#define DISPLAYTXTATTASHTML 0
#define THREAD_MAXINDENTATION 5
#define THREAD_LENGTHINDENTATION 6
#define THREAD_INDENTATIONCHAR "&nbsp;"

//STATISTICAL OR ADMINISTRATIVE OPTIONS
//When a NNTP group is open, we write that in the syslog
#define LOG_OPEN_NEWSGROUPS 1
//We write in the syslog the browser of the client
#define LOG_BROWSER_CLIENT 1

//in bytes
#define MAXLENGTH_IN_REPLY            50000
#define MAXLENGTH_IN_SIGN             1000
#define MAXLENGTH_IN_SUBSCRIBEDGROUPS 500
#define MAXLENGTH_FIELD_AB            500
#define MAXLENGTH_TO                  2000
#define MAXLENGTH_FROM                2000
#define MAXLONGATT                    30000000
#define UNHANDLESIZEATTACH            50000000

#define REPLY_BEGIN_LINE "> "

//***************  LOG ****
#define XLOGFACILITY LOG_MAIL
#define XLOGOPTIONS  LOG_PID
#define XLOGPRIORITY LOG_INFO

//****************  DISPLAY EN INDEX
//default for 640 wide screen
//#define LONGDISPLAYSUBJECT 35
//#define LONGDISPLAYFROM    20
//default for 800 wide screen
#define LONGDISPLAYSUBJECT 45
#define LONGDISPLAYFROM    30

//***************    OTHER PAGES
#define SERVER_IS_DISABLED      "/"APPNAME"/disabled.html"

//Only for PROGRAMMER
#define SEPLINE_ENV_INPUT "SEPLINE_ENV_INPUT"       

//Only for PROGRAMMER DEBUG
#define DEBUGGING_APP 0
#define SHOW_VALIDATE_HTML_URL 0

//FILEBROWSER module
//   Max uploaded file in bytes
#define FILEBROWSER_MAXUPLOADFILE 5000000

#endif





