
/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <pcap.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#include "link.h"

#define SLL_HDR_LEN 16				/* total header length */
#define SLL_ADDRLEN 8				/* length of address field */

struct sll_header 
{
   uint16_t sll_pkttype;			/* packet type */
   uint16_t sll_hatype;				/* link-layer address type */
   uint16_t sll_halen;				/* link-layer address length */
   uint8_t sll_addr[SLL_ADDRLEN];	/* link-layer address */
   uint16_t sll_protocol;			/* protocol */
};

static int decode_sll (const void *buf,size_t caplen)
{
   const struct sll_header *sll = buf;

   if (caplen < SLL_HDR_LEN || ntohs (sll->sll_protocol) != ETHERTYPE_IP)
	 return (-1);

   return (SLL_HDR_LEN);
}

struct link link_sll =
{
   .type	= DLT_LINUX_SLL,
   .decode	= decode_sll,
   .name	= "Linux cooked sockets"
};

