#
#
#
#

set udent_proc(get)		udent:get
set udent_proc(insert)		udent:insert
set udent_proc(delete)		udent:delete
set udent_proc(index)		udent:index
set udent_proc(subwidget)	udent:subwidget

Widget:DefineClass UpDownEntry {} udent:create udent:config udent_proc

set udent_repeat 0
set udent_repeat_init 500
set udent_repeat_interval 200

proc udent:create {w a} {
    entry $w.entry
    frame $w.buttons

    button $w.buttons.upButton -image ImageMiniUp \
	-padx 0 -pady 0 -takefocus 0 -highlightthickness 0
    button $w.buttons.downButton -image ImageMiniDown \
	-padx 0 -pady 0 -takefocus 0 -highlightthickness 0

    bind $w.buttons.upButton   <Button-1> [list udent:start_incr $w 1]
    bind $w.buttons.downButton <Button-1> [list udent:start_incr $w -1]
    bind $w.buttons.upButton   <ButtonRelease-1> {set udent_repeat 0}
    bind $w.buttons.downButton <ButtonRelease-1> {set udent_repeat 0}

    bind $w.entry <Key-Up>   [list udent:incr $w 1 0]
    bind $w.entry <Key-Down> [list udent:incr $w -1 0]

    global udent_conf
    set udent_conf($w,minimum) {}
    set udent_conf($w,maximum) {}

    udent:set_state $w editable

    pack $w.buttons.upButton $w.buttons.downButton -side top
    pack $w.entry -side left -fill x -expand yes
    pack $w.buttons -side left

    return $w
}

proc udent:config {w o v} {
    switch -- $o {
	-width {
	    $w.entry configure -width $v
	}
	-height {
	    $w.entry configure -height $v
	}
	-variable {
	    $w.entry configure -textvariable $v
	}
	-state {
	    udent:set_state $w $v
	}
	-upstep {
	    bind $w.buttons.upButton <Button-1> \
		[list udent:start_incr $w $v]
	    bind $w.entry <Key-Up> \
		[list udent:incr $w $v]
	}
	-downstep {
	    bind $w.buttons.downButton <Button-1> \
		[list udent:start_incr $w "-$v"]
	    bind $w.entry <Key-Down> \
		[list udent:incr $w "-$v"]
	}
	-minimum {
	    set udent_conf($w,minimum) $v
	}
	-maximum {
	    set udent_conf($w,maximum) $v
	}
	default {
	    return 1
	}
    }
    return 0
}

proc udent:set_state {w s} {
    switch $s {
	editable   {set entry_state normal;   set button_state normal}
	buttononly {set entry_state readonly; set button_state normal}
	disabled   {set entry_state disabled; set button_state disabled}
    }
    Widget:SetEntryState $w.entry $entry_state
    $w.buttons.upButton   configure -state $button_state
    $w.buttons.downButton configure -state $button_state
}

proc udent:subwidget {w a} {
    switch $a {
	entry   {return $w.entry}
	buttons {return $w.buttons}
	*       {return ""}
    }
}

proc udent:incr {w step} {
    global udent_conf

    set v [$w.entry get]
    if {$v == ""} {
	$w.entry insert 0 0
    } else {
	incr v $step
	if {$step > 0} {
	    set max $udent_conf($w,maximum)
	    if {$max == "" || $v <= $max} {
		$w.entry delete 0 end
		$w.entry insert 0 $v
	    }
	} elseif {$step < 0} {
	    set min $udent_conf($w,minimum)
	    if {$min == "" || $v >= $min} {
		$w.entry delete 0 end
		$w.entry insert 0 $v
	    }
	}
    }
}

proc udent:start_incr {w step} {
    global udent_repeat udent_repeat_init

    udent:incr $w $step
    set udent_repeat 1
    after $udent_repeat_init [list udent:repeat_incr $w $step]
}

proc udent:repeat_incr {w step} {
    global udent_repeat udent_repeat_interval

    if $udent_repeat {
	udent:incr $w $step
	after $udent_repeat_interval [list udent:repeat_incr $w $step]
    }
}

proc udent:get {w a} {
    eval $w.entry get $a
}

proc udent:insert {w a} {
    eval $w.entry insert $a
}

proc udent:delete {w a} {
    eval $w.entry delete $a
}

proc udent:index {w a} {
    eval $w.entry index $a
}

proc udent:test {} {
    UpDownEntry .udent -width 12
    pack .udent
}
