/*
 * QToggleButton.h
 * $Id: QToggleButton.h,v 1.3 2001/11/20 16:23:48 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class QToggleButton
//  Purpose     : Provides funcionality of a togglebutton with two pixmaps


#ifndef __QTOGGLEBUTTON_H_
#define __QTOGGLEBUTTON_H_


// Qt
///////
#include <qpushbutton.h>


// System
///////////


// Own
///////////


// Forward declarations
/////////////////////////
class QString;
class QPixmap;
class QWidget;

// for Qt 2.x compatibility
#if QT_VERSION < 300
#define Q_CHECK_PTR CHECK_PTR
#endif


/// Togglebutton with two different strings or pixmaps.
/**
  * This class implements a togglebutton with two different
  * strings or pixmaps which will be exchanged when the
  * button is toggled.
  */

class QToggleButton : public QPushButton
{
  Q_OBJECT

public:
  /** Default constructor. */
  QToggleButton( QWidget *parent=0, const char *name=0 );
  /** The same as above but you can also pass the textes with it. */
  QToggleButton( const char *text1, const char *text2, QWidget *parent=0, const char *name=0 );
  /** Default destructor. */
  ~QToggleButton();

  void setText( const QString &) {};        // overwrite inherited method
  void setPixmap( const QPixmap &) {};      // overwrite inherited method

  /** Sets the text which is shown when pressed or raised. */
  void setText( const QString &up_text, const QString &down_text = "" );
  /** Sets the pixmap which is shown when pressed or raised. */
  void setPixmap( const QPixmap &up_pixmap, const QPixmap &down_pixmap );

private slots:
  void togglePixmap(bool on);

private:
  QString toggled_btext;
  QPixmap *toggled_bpixmap;
};


#endif  // __QTOGGLEBUTTON_H_
