/*
Remote Access Session v0.7 detectos.c - Code By Angel Ramos <seamus@salix.org>
*/

#include "raccess.h"

void queso (char* host, char *port)	{
	int fds[2];
	pid_t pid;
	int child_status;
	char readbuffer[1024];
	char *execargs[5];
	char program_path[512];
	static  char BINFILES[255] = LOCATION_BIN_FILES;
	char *tok;
 	
	pipe (fds);
	pid = fork ();
	if (pid != 0)   {
		close (fds[1]);
		waitpid (pid, &child_status, 0);
		read (fds[0], readbuffer, sizeof (readbuffer));
		tok = strtok (readbuffer, "\n");
		printf ("%s\n", tok);
		if ((filedesc = fopen (host, "a")) == NULL)	{
			printf ("Can't open log file.\n");
		}else	{
			fprintf (filedesc, "Remote OS: %s\n", tok);
			fclose (filedesc);
		}
	} else  {
		snprintf (program_path, sizeof (program_path), "%s/queso", BINFILES);
		execargs[0] = program_path;
		execargs[1] = "-p";
		execargs[2] = port;
		execargs[3] = host;
		execargs[4] = NULL;

		close (fds[0]);
		close (1);
		dup2 (fds[1], 1);
		execve (execargs[0], execargs, NULL);
	}
}

void detectos (char *host, int port)	{
	uid_t userid;
 	char cport[6];
 	
 	userid = getuid ();
	if (userid != 0)	{
 		printf ("Not root user. You need to be root to OS detect!!.\n");
 		return;
 	}
 	printf ("--Detecting Remote OS...\n");
 	snprintf (cport, sizeof (cport), "%d", port);
 	queso (host, cport);
} 
 
