#include "allegro.h"
#include "defs.h"

#include "spaceobj.h"

#include "hull_weapon.h"
#include "hull_weapon_laser.h"

#define LASER_DIST 4

Laser_WHull::Laser_WHull( int str ):
HullWeapon( 0, 1, 1 ) {
	shade = new int[ LASER_DIST ];
	switch( str ) {
		case 0  : {
			life = 21;
			strength = 1;
			color = makecol( 0,240,130 );
			break;
		}
		case 1  : {
			life = 21;
			strength = 3;
			color = makecol( 250,120,50 );
			break;
		}
	}
	blend_palette( shade, LASER_DIST, color, makecol( 255, 255, 255 ) );
}


bool Laser_WHull::Collide( int mx, int my, SpaceObject * check ) {
	for ( int qy = my; qy <= my + GetLife() * 3/2; qy+=5 )
		for ( int qx = mx - LASER_DIST; qx <= mx+LASER_DIST; qx += 3 )
			if ( check->HitMe( qx, qy ) )
				return true;
	return false;
}


void Laser_WHull::Draw( BITMAP * who, int x, int y ) {

	int x1 = x-LASER_DIST;
	int y1 = y;
	int x2 = x+LASER_DIST;
	int y2 = y+(int)GetLife() * 3/2;

	rectfill( who, x1, y1+1, x2, y2-1, shade[0] );

	for ( int q = 1; q < LASER_DIST; q++ )
		rectfill( who, x1+q, y1, x2-q, y2, shade[q] );

}


Laser_WHull::~Laser_WHull() {
	delete[] shade;
}
