/******************************************************************************
*		       							      *
* engine/debug.h (part of rcalc)				       	      *
* Copyright (C) 2001 Free Software Foundation, Inc.			      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

/* Include this file for access to rcalc's debugging functions.
*/

#ifndef __RC_DEBUG_H__
#define __RC_DEBUG_H__

#include <glib.h>


typedef enum
{
	RC_DBG_TOPLEVEL	= 0xF,
	RC_DBG_ENGINE	= 0x1,
	RC_DBG_GNOMEUI	= 0x2,
}
RcDebug;


void		rc_debug_add_state		( RcDebug      what  );

void		rc_debug			( RcDebug      msgtype,
						  const gchar *format,
						  ... );

#endif /* __RC_DEBUG_H__ */
