/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include <xclass/OIniFile.h>
#include "ConnectionInfo.h"


namespace rfb {



void readConnectionInfo( const char* filename, ConnectionInfo &connectionInfo )
{
  OIniFile defaultIniFile( filename, INI_READ );
  
  char section[256];
  char value[1024];
  while( defaultIniFile.GetNext( section ) ) {
    if ( !strcasecmp( "connection", section ) ) {
      if ( defaultIniFile.GetItem( "host", value ) )             strcpy( connectionInfo.host, value );
      if ( defaultIniFile.GetItem( "port", value ) )             connectionInfo.display = atoi( value ) - 5900;
    } else
    if ( !strcasecmp( "options", section ) ) {
      if ( defaultIniFile.GetItem( "viewonly", value ) )         connectionInfo.viewOnly = atoi( value );
      if ( defaultIniFile.GetItem( "fullscreen", value ) )       connectionInfo.fullscreenMode = atoi( value );
      if ( defaultIniFile.GetItem( "8bit", value ) )             connectionInfo.restrictPixels = atoi( value );
      if ( defaultIniFile.GetItem( "shared", value ) )           connectionInfo.requestSharedSession = atoi( value );
      if ( defaultIniFile.GetItem( "swapmouse", value ) )        connectionInfo.swapMouseButtons = atoi( value );
      if ( defaultIniFile.GetItem( "belldeiconify", value ) )    connectionInfo.deiconifyOnBell = atoi( value );
      if ( defaultIniFile.GetItem( "emulate3", value ) )         connectionInfo.emulate3Buttons = atoi( value );
      if ( defaultIniFile.GetItem( "framerate", value ) )        connectionInfo.framerate = atoi( value );
      if ( defaultIniFile.GetItem( "disableclipboard", value ) ) connectionInfo.disableClipboardTransfer = atoi( value );
      if ( defaultIniFile.GetItem( "scale_num", value ) )        connectionInfo.scaleFactor = atoi( value );
      if ( defaultIniFile.GetItem( "scale_den", value ) )        connectionInfo.scaleDivisor = atoi( value );
      if ( defaultIniFile.GetItem( "zlibcompression", value ) )  connectionInfo.useZlib = atoi( value );
    }
  }
}

void writeConnectionInfo( const char* filename, ConnectionInfo &connectionInfo )
{
        OIniFile defaultIniFile( filename, INI_WRITE );
        
        char tmp[1024];

        defaultIniFile.PutNext( "connection" );
        defaultIniFile.PutItem( "host", connectionInfo.host );
        sprintf( tmp, "%i", connectionInfo.display+5900 );
        defaultIniFile.PutItem( "port", tmp );
        defaultIniFile.PutNewLine();

        defaultIniFile.PutNext( "options" );
        sprintf( tmp, "%i", connectionInfo.viewOnly );
        defaultIniFile.PutItem( "viewonly", tmp );
        sprintf( tmp, "%i", connectionInfo.fullscreenMode );
        defaultIniFile.PutItem( "fullscreen", tmp );
        sprintf( tmp, "%i", connectionInfo.restrictPixels );
        defaultIniFile.PutItem( "8bit", tmp );
        sprintf( tmp, "%i", connectionInfo.requestSharedSession );
        defaultIniFile.PutItem( "shared", tmp );
        sprintf( tmp, "%i", connectionInfo.swapMouseButtons );
        defaultIniFile.PutItem( "swapmouse", tmp );
        sprintf( tmp, "%i", connectionInfo.deiconifyOnBell );
        defaultIniFile.PutItem( "belldeiconify", tmp );
        sprintf( tmp, "%i", connectionInfo.emulate3Buttons );
        defaultIniFile.PutItem( "emulate3", tmp );
        sprintf( tmp, "%i", connectionInfo.framerate );
        defaultIniFile.PutItem( "framerate", tmp );
        sprintf( tmp, "%i", connectionInfo.disableClipboardTransfer );
        defaultIniFile.PutItem( "disableclipboard", tmp );
        if ( connectionInfo.scale ) {
          sprintf( tmp, "%i", connectionInfo.scaleFactor );
          defaultIniFile.PutItem( "scale_num", tmp );
          sprintf( tmp, "%i", connectionInfo.scaleDivisor );
          defaultIniFile.PutItem( "scale_den", tmp );
        }
        sprintf( tmp, "%i", connectionInfo.useZlib );
        defaultIniFile.PutItem( "zlibcompression", tmp );
}



} // namespace rfb

