#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "xmldocbook_generator.h"
#include "util.h"


char               *
RB_XMLDB_Get_Default_Extension( void )
{
    return ".xml";
}

void
RB_XMLDB_Generate_String( FILE * dest_doc, char *a_string )
{
    int                 i;
    int                 l = strlen( a_string );
	unsigned char       c;

    for ( i = 0; i < l; ++i )
    {
		c = a_string[i];
        RB_XMLDB_Generate_Char( dest_doc, c );
    }
}


void
RB_XMLDB_Generate_Label( FILE * dest_doc, char *name )
{
    fprintf( dest_doc, "<anchor id=\"%s\"/>\n", name );
}


/****f* Generator/RB_XMLDB_Generate_Char
 * NAME
 *   RB_XMLDB_Generate_Char
 * SYNOPSIS
 *   void RB_XMLDB_Generate_Char( FILE * dest_doc, int c )
 * FUNCTION
 *   Switchboard to RB_XMLDB_Generate_Char
 * SOURCE
 */

void
RB_XMLDB_Generate_Char( FILE * dest_doc, int c )
{
    switch ( c )
    {
    case '\n':
        assert( 0 );
        break;
    case '\t':
        assert( 0 );
        break;
    case '<':
        fprintf( dest_doc, "&lt;" );
        break;
    case '>':
        fprintf( dest_doc, "&gt;" );
        break;
    case '&':
        fprintf( dest_doc, "&amp;" );
        break;
    default:
		RB_FputcLatin1ToUtf8( dest_doc, c );
		break;
    }
}

/*****/

void
RB_XMLDB_Generate_Header_Start( FILE * dest_doc,
                                struct RB_header *cur_header )
{
    fprintf( dest_doc, "<section id=\"%s\">\n", cur_header->unique_name );
    fprintf( dest_doc, "<title>\n" );
    RB_XMLDB_Generate_String( dest_doc, cur_header->name );
    fprintf( dest_doc, "</title>\n" );
}

void
RB_XMLDB_Generate_Header_End( FILE * dest_doc, struct RB_header *cur_header )
{
    fprintf( dest_doc, "</section>\n" );
}

void
RB_XMLDB_Generate_Link( FILE * dest, char *dest_name, char *filename,
                        char *labelname, char *linkname, int in_fold )
{
    fprintf( dest, "<link linkend=\"%s\">", labelname );
    RB_XMLDB_Generate_String( dest, linkname );
    fprintf( dest, "</link>" );
}

void
RB_XMLDB_Generate_Doc_Start( FILE * dest_doc, char *src_name, char *name,
                             char toc )
{
	fprintf( dest_doc, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    fprintf( dest_doc, "%s",
             "<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook XML V4.1.2//EN\" \n"
             "\"http://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd\">\n"
             "<article lang=\"en\">\n" );
    fprintf( dest_doc, "%s",
             "<articleinfo> <title>API Documentation</title> </articleinfo>\n" );
}


void
RB_XMLDB_Generate_Doc_End( FILE * dest_doc, char *name )
{
    fprintf( dest_doc, "%s", "</article>\n" );
}


void
RB_XMLDB_Generate_Item_Begin( FILE * dest_doc )
{
    fprintf( dest_doc, "%s", "<literallayout class=\"monospaced\">\n" );
}



void
RB_XMLDB_Generate_Item_End( FILE * dest_doc )
{
    fprintf( dest_doc, "%s", "</literallayout>\n" );
}


void
RB_XMLDB_Generate_BeginSection( FILE * dest_doc, int depth, char *name )
{
    fprintf( dest_doc, "%s", "<section>\n<title>" );
    RB_XMLDB_Generate_String( dest_doc, name );
    fprintf( dest_doc, "%s", "</title>\n" );
}

void
RB_XMLDB_Generate_EndSection( FILE * dest_doc, int depth, char *name )
{
    fprintf( dest_doc, "%s", "</section>\n" );
}

void
RB_XMLDB_Generate_Item_Name( FILE * dest_doc, char *name )
{
    RB_XMLDB_Generate_String( dest_doc, name );
}


void
RB_XMLDB_Generate_False_Link( FILE * dest_doc, char *name )
{
    RB_XMLDB_Generate_String( dest_doc, name );
}
