/*
 * robutils.h
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file
  * Declares utility classes
  */

#ifndef __RT_ROBUTILS__
#define __RT_ROBUTILS__

#include <rtsystem.h>

namespace rt {

/// a section of code which should not be abortable by the user.
/// It is protected by a breakHandler which defers the break until
/// the section is finished. (You can also ignore the break completely.)
class NoBreakSection {
public: // static:
	static void breakHandler(lrt::System::BreakType type);
public:
	/// enters the section automatically
	NoBreakSection(bool ignoreBreak = false);
	/// leaves the section automatically
	~NoBreakSection();

	/// re-enters the section 
	void enter();
	/// leaves the section. If we don't ignore breaks, and the
	/// user in fact breaked during the section, exits the program now. 
	void leave();

private: // static:
	static bool breakOccured; // was there a break inside the section?
	static NoBreakSection* inside; // are we inside a section? if yes, it's that one
private:
	bool ignoreBreak; 
};

}; // namespace

#endif
