
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

/* -*- mode: C; c-basic-offset: 4  -*- */ 
#ifndef __RXP_H__
#define __RXP_H__

typedef struct _RXpDecoder RXpDecoder;

struct _RXpDecoder {
    /* The encoded data coming in */
    char *data;
    /* The current position of the incoming data */
    char *cur_pos;
    /* The length of the original block that you
     * are decoding */
    unsigned int buflen;
    /* The current decoded length of the block */
    unsigned int length;
};


typedef struct _RXpEncoder RXpEncoder;

struct _RXpEncoder {
    /* The encoded data block */
    char *data;
    /* The current position in that block to which
     * to entries will be appended */
    char *cur_pos;
    /* The length of the used portion of the block */
    unsigned int length;
    /* The amount of space allocated for the block */
    unsigned int alloced;
};


/* The codes for RXp datatypes. 
 *
 * If you need to define your own, simply use RXP_TYPE_USER + 1, 2, etc.
 */
typedef unsigned int RXpDataType;

#define RXP_TYPE_INT32          1
#define RXP_TYPE_UINT32         2
#define RXP_TYPE_FLOAT          3
#define RXP_TYPE_DOUBLE         4
#define RXP_TYPE_STR            5
#define RXP_TYPE_DATA           6
#define RXP_TYPE_RBUF           7
#define RXP_TYPE_NULL_RBUF      8
#define RXP_TYPE_MSG_END        9
#define RXP_TYPE_USER           10


/* Error values. */
#define RXP_ERROR_NULL          1
#define RXP_ERROR_LENGTH        2
#define RXP_ERROR_TYPE          3


RXpEncoder *
rxp_encoder_new (void);

char *
rxp_encoder_get_buffer (RXpEncoder *encoder, unsigned int *length);

void
rxp_encoder_reset (RXpEncoder *encoder);

void
rxp_encode_msg_end (RXpEncoder *encoder);

void
rxp_encode_type (RXpEncoder *encoder, RXpDataType type);

void
rxp_encode_ruint32 (RXpEncoder *encoder, ruint32 value);

void
rxp_encode_rint32 (RXpEncoder *encoder, rint32 value);

void
rxp_encode_float (RXpEncoder *encoder, float value);

void
rxp_encode_double (RXpEncoder *encoder, double value);

void
rxp_encode_rbuf (RXpEncoder *encoder, RBuf *value);

void
rxp_encode_str (RXpEncoder *encoder, char *str);

void
rxp_encode_data (RXpEncoder *encoder, void *data, int len);

void
rxp_encoder_free (RXpEncoder *encoder);


RXpDataType
rxp_decode_peek_next_type (RXpDecoder *decoder);

RXpDecoder *
rxp_decoder_new (char *data, int length);

void
rxp_decoder_free (RXpDecoder *decoder);

unsigned int
rxp_decoder_msg_length (RXpDecoder *decoder);

void
rxp_decoder_reset (RXpDecoder *decoder, char *data, int length);

int 
rxp_decode_type (RXpDecoder *decoder, RXpDataType *type);

int 
rxp_decode_rint32 (RXpDecoder *decoder, rint32 *value);

int 
rxp_decode_ruint32 (RXpDecoder *decoder, ruint32 *value);

int 
rxp_decode_float (RXpDecoder *decoder, float *value);

int 
rxp_decode_double (RXpDecoder *decoder, double *value);

int 
rxp_decode_rbuf (RXpDecoder *decoder, RBuf **value);

int 
rxp_decode_str (RXpDecoder *decoder, char *buf, int len);

int 
rxp_decode_data (RXpDecoder *decoder, void *buf, int buflen, int * len);

#endif /* __RXP_H__ */


