/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *  The Robj type
 *
 *  $Id: robjobject.h,v 1.6 2004/02/27 04:47:27 warnes Exp $
 *
 */


/* The R object type */
typedef struct {
  PyObject_HEAD
  SEXP R_obj;		/* R object itself */
  int conversion;		/* 0: no conversion
				   1: basic conversion
				   2: class conversion
				   3: proc conversion */
} RobjObject;

#ifdef _WIN32
  extern PyTypeObject Robj_Type;
#else
  extern DL_IMPORT(PyTypeObject) Robj_Type;
#endif

#define Robj_Check(v)	((v)->ob_type == &Robj_Type)

RobjObject *Robj_new(SEXP, int);
